/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _ACTIVITYVIEWER_H_
#define _ACTIVITYVIEWER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <klistview.h>


class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class KListView;
class QPushButton;
class QLabel;
class KProcess;
class KConfig;
class KURLRequester;
class KListViewItem;
class KListViewSearchLine;


/**
 * This class serves as the main window for Activityviewer.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Activityviewer :  public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Activityviewer(QWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Activityviewer();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load();
    void  setDirName(QString);
    void createQuarDir();
    QString getFileName(QString);
    QString getVirusName(QString);
    QString getWhen(QString);
    QString getSelectedVirusName();
    void insertItem(const  QString &date, const  QString &type, const QString &event, const QString &file);
    KListViewSearchLine* kLineEdit1;

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);


private slots:
    void allActivity();
    void allActivityOfType(const QString &type);
    void allActivityOfDate(const QString &days);

private:
    void setupAccel();
    void setupActions();
    void populateActivity();

private:
    //ActivityviewerView *m_view;

  /*  KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;*/


signals:
    void itemSelected(QString abs_filename, int line);

public slots:

private slots:

    void slotOptions();
    //void patternTextChanged( const QString &);
private:

    QLineEdit *template_edit;
    QComboBox *check_combo, *days_combo;
    KURLRequester *dir_combo;
    QCheckBox *recursive_box;
    KListView *currentbox;
    QPushButton *search_button, *cancel_button, *refresh_button, *search_button3, *cancel_button3;
    QLabel *status_label, *matches_label;
    KProcess *childproc;
    QString buf;
    KConfig* config;
    QStringList lastQuarItems;
    QStringList lastHistoryItems;
    QStringList lastQuarLocations;
    QStringList lastSearchPaths;
    QString quarloc;
    QPopupMenu* qmenu;
    QPopupMenu* hmenu;
    QStringList activity;
};

    
    class EventListItem : public KListViewItem
    {
        public:
            EventListItem( KListView *parent, QString label1, QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null);
            ~EventListItem();

            void paintCell ( QPainter * p, const QColorGroup & cg, int column, int width, int align );
 
    };


#endif // _Activityviewer_H_
