/***************************************************************************
                          logviewwidget.cpp  -  description
                             -------------------
    begin                : Wed Feb 7 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@wanadoo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>

#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "logviewwidget.h"

LogViewWidget::LogViewWidget( QList<ABProcess> * p, QStrList * l, bool b) : QSemiModal(0,0,b) {
	setName( "LogViewBase" );
	resize( 588, 413 );
	setCaption( i18n( "Form1" ) );
	LogViewBaseLayout = new QGridLayout( this );
	LogViewBaseLayout->setSpacing( 6 );
	LogViewBaseLayout->setMargin( 11 );

	MultiLineEdit1 = new QMultiLineEdit( this, "MultiLineEdit1" );

	LogViewBaseLayout->addMultiCellWidget( MultiLineEdit1, 0, 1, 0, 0 );

	Layout1 = new QVBoxLayout;
	Layout1->setSpacing( 6 );
	Layout1->setMargin( 0 );

    PushButton1 = new QPushButton( this, "PushButton1" );
    PushButton1->setText( i18n( "Print" ) );
    Layout1->addWidget( PushButton1 );

    PushButton2 = new QPushButton( this, "PushButton2" );
    PushButton2->setText( i18n( "Save" ) );
    Layout1->addWidget( PushButton2 );

    PushButton3 = new QPushButton( this, "PushButton3" );
    PushButton3->setText( i18n( "Exit" ) );
    Layout1->addWidget( PushButton3 );

    LogViewBaseLayout->addLayout( Layout1, 0, 1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    LogViewBaseLayout->addItem( spacer, 1, 1 );

    // signals and slots connections
    connect( PushButton2, SIGNAL( clicked() ), this, SLOT( slotSave() ) );
    connect( PushButton3, SIGNAL( clicked() ), this, SLOT( slotExit() ) );
    connect( PushButton1, SIGNAL( clicked() ), this, SLOT( slotPrint() ) );
	pl = p;
	tl = l;
	setLog();
}

LogViewWidget::~LogViewWidget(){
	delete tl;
}

void LogViewWidget::slotExit(){
	this -> hide();
}

void LogViewWidget::slotSave(){
	bool b = true;
	QString filename;
	QString t("");
	filename = KFileDialog::getSaveFileName(getenv("HOME"),0);
	QFileInfo fi(filename);
	if (fi.exists()){
		b = false;
		QString t(i18n("Overwrite file\n"));
		t = t + fi.absFilePath() + "?";
		if (KMessageBox::questionYesNo(this,i18n("Overwrite file?"),t) == KMessageBox::Yes)
			b = true;
	}
	if (b){
		QFile file(filename);
		file.open(IO_WriteOnly);
		file.writeBlock(MultiLineEdit1 -> text(), MultiLineEdit1 -> text().length());
		file.close();
	}
}

void LogViewWidget::slotPrint(){
	QString filename("/tmp/kleandisk.log");
	QFile file(filename);
	file.open(IO_WriteOnly);
	file.writeBlock(MultiLineEdit1 -> text(), MultiLineEdit1 -> text().length());
	file.close();
	printLog = new KProcess();
	*printLog << "lpr";
	*printLog << "/tmp/kleandisk.log";
	connect(printLog, SIGNAL(processExited(KProcess *)), SLOT(slotPrintExited()));
	printLog -> start(KProcess::NotifyOnExit, KProcess::AllOutput);

}

void LogViewWidget::slotPrintExited(){
	delete printLog;
}

void LogViewWidget::setLog(){
	QString l("");
	if (tl){
		for (uint i = 0; i < tl -> count(); i++)
			l += QString(tl -> at(i)) + "\n";
		l += "\n";
	}
	for (uint i = 0; i < pl -> count(); i++){
		l += i18n("Output from process: ");
		l += pl -> at(i) -> name();
		l += "\n";
		l += "-----\n";
		for (uint j = 0; j < pl -> at(i) -> output -> count(); j++)
		l += QString (pl -> at(i) -> output -> at(j)) + "\n";
		l += "-----\n\n";
		l += i18n("Exit status: ");
		l += pl -> at(i) -> name();
		if (pl -> at(i) -> std_err.length() == 0)
			l += i18n(" ended without errors.");
		else{
			l += i18n(" ended with errros!");
			l += "\n";
			l += "Error log:\n";
			l += "-----\n";
			l += pl -> at(i) -> std_err;
			l += "-----";
		}
		l += "\n\n\n";
	}
	MultiLineEdit1 -> setText(l);
}

