/***************************************************************************
                          restorewizard.h  -  description
                             -------------------
    begin                : Sun Feb 11 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@wanadoo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef RESTOREWIZARD_H
#define RESTOREWIZARD_H

#include <kconfig.h>

#include <abprocess.h>
#include <buttonlabelwidget3.h>
#include <logviewwidget.h>
#include <restorebase.h>

/**
  *@author Arjan Buursink
  */

class RestoreWizard : public RestoreBase  {
	Q_OBJECT
public:
	RestoreWizard();
	~RestoreWizard();
private:
	void addArchives(QString);
	QStrList archiveDirs;
	KConfig * config;
	void slotArchiveSelected(QListViewItem*);
	void slotBrowseArchiveFolder();
	void slotBrowseRestoreFolder();
	void slotChangeArchiveFolder(int);
	void slotDeleteArchive();
	void slotYesClicked();
	void slotNoClicked();
	void slotCheckExistence();
	void slotViewLog();
	void enableItems(QListView *,bool);
	ABProcess * tar;
	bool tarExited;
	QString archive(){return arch;};
	QString arch;
	bool fileExists(QListViewItem*);
	void accept();
	void slotSelectAll();
	void slotDeSelectAll();
	unsigned int numSelected();
	int overWrite();
	bool accepted; // this variable is set after user clicks 'finish'. It is used in slotTarExited
	ButtonLabelWidget3 * progress;
	LogViewWidget * logView;
private slots:
	void slotTarExited();
};

#endif
