/***************************************************************************
                          kcontainer.h  -
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.10 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONTAINER_H
#define KCONTAINER_H

#include <qvaluelist.h>
#include "kobject.h"

typedef QValueList<int> IntList;

class KContainerImpl;
class KCntIterator;

/** 
 * @short Bridge class for @ref KContainerImpl class.
 * 
 * @author Sergio Moretti
 * 
 * @version $Id: kcontainer.h,v 1.10 2001/03/22 09:26:52 sergio Exp $
 */
class KContainer : public KObject 
{
   friend class KObject;
   
public:
   typedef QValueList<KContainer> List;

   friend class KCntIterator;

   KContainer() {}
   static KContainer null() { return KContainer(); }

   KObject::List globals() const;
   KObject findGlobal(int type) const;

   bool isEmpty() const;
   void clear() const;
   // items creation/deletion
   KObject itemCopy(const QDomElement &e) const;
   void itemRemove(const KObject &item) const;
   KObject itemFindId(int id) const;
   KObject itemSearch(int id) const;
   int itemFind(const KObject &item) const;
   KObject itemAt(int index) const;
   KObject itemFirst() const;
   KObject itemLast() const;
   //KObject itemNext() const;
   //KObject itemPrev() const;
   int itemCount() const;
   int itemActiveCount() const;
   int itemType() const;
   IntList itemTypes() const;

   // config entries

   PriorityPolicy getPriorityPolicy() const;
   void setPriorityPolicy(PriorityPolicy p) const;

protected:
   KContainer(KContainerImpl * impl);
   KContainerImpl * impl() const;
   // masked methods
   KObject::toTransfer;
};

#endif // KCONTAINER_H

/* Local Variables: */
/* mode: c++ */
/* End: */
