/***************************************************************************
                          kcontainerview.h  -  description
                             -------------------
    begin                : Thu Dec 21 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.6 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONTAINERVIEW_H
#define KCONTAINERVIEW_H

#include <qdragobject.h>
#include <kconfig.h>
#include "kcontainer.h"
#include "ktransfer.h"
#include "ktmanager.h"

class KMagoDoc;
class KMagoView;

/**
 * @short Base for all View class.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kcontainerview.h,v 1.6 2001/03/29 08:38:48 sergio Exp $
 */

class KContainerView 
{

public:
   typedef void (KMagoView::*Callback)(KObject);

   enum MimeTypes 
   {
      MimeTManagerList = 0,
      MimeTransferList,
      MimeUriList,
      MimeText,

      MimeTypeNum
   };
   
   static const char MIMETYPE[MimeTypeNum][50];

public:
   KContainerView(KMagoDoc *doc, Callback cb, KContainer c);
   virtual ~KContainerView();

   virtual const char * name() const = 0;
   KMagoView * view() const;
   KMagoDoc * doc() const;
   virtual KContainer container() const;
   virtual void setContainer(KContainer c);

   static bool acceptDrop(const QDropEvent *event, KContainer target);
   static bool dropItemList(KContainer source, KContainer target, bool move, 
			    QDomDocument dom);
   static bool dropUriList(KMagoDoc *doc, KContainer target, QStrList &uris);
   static bool dropText(KMagoDoc *doc, KContainer target, const QString &text);

   static const char * transferFormat(int i);
   static bool transferCanDecode(const QMimeSource *e);
   static QByteArray transferEncodedData(const KTransfer::List &trns, 
					 const char* mimetype);
   static bool transferDragEnabled(KTransfer t);
   static void dropTransferList(QDropEvent *event, KMagoDoc *doc, 
				KContainer target);
   static KTManager selectManager(KMagoDoc* doc);

   static const char * managerFormat(int i);
   static bool managerCanDecode(const QMimeSource *e);
   static QByteArray managerEncodedData(const KTManager::List &mngrs, 
					const char* mimetype);
   static bool managerDragEnabled(KTManager m);
   static void dropTManagerList(QDropEvent *event, KContainer target);

   static bool managerToClipboard(KTManager m, bool cut);
   static bool transferToClipboard(KTransfer t, bool cut);
   static bool managersPasteFromClipboard(KMManager m);
   static bool transfersPasteFromClipboard(KTManager m);
   static bool urisPasteFromClipboard(KMagoDoc *doc);
   static bool textsPasteFromClipboard(KMagoDoc *doc);

   virtual void itemAdd(KObject item) = 0;
   virtual void itemRemove(KObject item) = 0;
   virtual void itemSelect(KObject item) = 0;
   virtual void itemUpdate(KObject item) = 0;
   virtual void itemUpdateText(KObject item) = 0;
   virtual KObject itemFirst() const = 0;
   virtual KObject itemBelow(KObject item) const = 0;
   virtual KObject itemAbove(KObject item) const = 0;
   virtual void initView() = 0;
   virtual void reset();
   virtual void clear() = 0;
   virtual void saveSettings(KConfig *config) = 0;
   virtual void applySettings(KConfig *config) = 0;
   virtual void setSortBy(ModIndex p, bool increasing = true) = 0;
   virtual ModIndex sortBy() const = 0;
   virtual bool sortDir() const = 0;

   virtual void setOrientation(bool) {}

//signals:
   void itemSelectionChanged(KObject item) { (view()->*_callback)(item); }

private:
   KMagoDoc *_doc;
   KContainer _cnt;
   Callback _callback;
};

/**
 * @short Drag object for @ref KTransferImpl objects.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kcontainerview.h,v 1.6 2001/03/29 08:38:48 sergio Exp $
 */

class KTransferListDrag : public QDragObject 
{
   Q_OBJECT

public:
   KTransferListDrag(QWidget *dragSource, const char *name = 0);
   virtual ~KTransferListDrag() {}
   const char * format(int i) const;
   void append(KTransfer t);
   QByteArray encodedData(const char* mimetype) const;
   static bool canDecode(const QMimeSource *e);

private:
   KTransfer::List trns;
};

/**
 * @short Drag object for @ref KTManager object.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kcontainerview.h,v 1.6 2001/03/29 08:38:48 sergio Exp $
 */

class KTManagerListDrag : public QDragObject 
{
   Q_OBJECT

public:
   KTManagerListDrag(QWidget *dragSource, const char *name = 0);
   virtual ~KTManagerListDrag() {}
   const char * format(int i) const;
   virtual QByteArray encodedData(const char* mimetype) const;
   static bool canDecode(const QMimeSource *e);
   virtual void append(const KTManager item);

private:
   KTManager::List mngrs;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
