/***************************************************************************
                          kdlgmanager1.cpp  -  description
                             -------------------
    begin                : Wed Sep 6 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.17 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kfiledialog.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <klocale.h>
#include <qhbox.h>
#include "ktmanager.h"
#include "kdlgmanager1.h"

KDlgManager1::KDlgManager1(KTManager m, QWidget *parent, 
			   const char *name) : QWidget(parent,name) 
{
   mngr = m;
   initDialog();
   _oldGlobal = mngr.getGlobal();
   //cbtGlobal->setChecked(mngr.getGlobal());
   //slotSetGlobal(mngr.getGlobal());
   //cbtGlobal->setEnabled(!mngr.isGlobal());
   if (mngr.isNormal()) {
      slotSetGlobal(mngr.useGlobal());
      connect(this, SIGNAL(sigGlobalChange(bool)), 
	      this, SLOT(slotSetGlobal(bool)));
   } else
      init();
}

KDlgManager1::~KDlgManager1()
{
}

void KDlgManager1::accept()
{
   if (mngr.isNormal() && mngr.useGlobal())
      return;
   int maxband = QString(lneMaxBand->text()).toInt();
   int minband = QString(lneMinBand->text()).toInt();
   int maxconn = QString(lneMaxConn->text()).toInt();
   //mngr.setGlobal(cbtGlobal->isChecked());
   mngr.setPriorityPolicy(static_cast<PriorityPolicy>(
			     cmbPriority->currentItem()));
   mngr.setAutoDownload(cbtAutoDownload->isChecked());
   mngr.setAutoRemove(cbtRemoveCompleted->isChecked());
   mngr.setMaxBandwidth(maxband);
   mngr.setMinBandwidth(minband);
   mngr.setMaxConnection(maxconn);
   mngr.setDefaultType(_typeList[cmbType->currentItem()]);
#ifndef KURLREQ_ERR
   mngr.setDownloadDir(cmbDDir->url());
   mngr.setWorkingDir(cmbWDir->url());
   mngr.setLogFile(cmbLog->url());
#else
   mngr.setDownloadDir(lneDDir->text());
   mngr.setWorkingDir(lneWDir->text());
   mngr.setLogFile(lneLog->text());
#endif
   //mngr->update();
}

void KDlgManager1::reject() 
{
   mngr.setGlobal(_oldGlobal);
}

void KDlgManager1::init() 
{
   cmbPriority->setCurrentItem(mngr.getPriorityPolicy());
   cbtAutoDownload->setChecked(mngr.getAutoDownload());
   cbtRemoveCompleted->setChecked(mngr.getAutoRemove());
   lneMaxBand->setText(QString::number(mngr.getMaxBandwidth()));
   lneMinBand->setText(QString::number(mngr.getMinBandwidth()));
   lneMaxConn->setText(QString::number(mngr.getMaxConnection()));
#ifndef KURLREQ_ERR
   cmbDDir->setURL(mngr.getDownloadDir().absPath());
   cmbWDir->setURL(mngr.getWorkingDir().absPath());
   cmbLog->setURL(mngr.getLogFile());
#else
   lneDDir->setText(mngr.getDownloadDir().absPath());
   lneWDir->setText(mngr.getWorkingDir().absPath());
   lneLog->setText(mngr.getLogFile());
#endif
   cmbType->clear();
   _typeList.clear();
   IntList lst = mngr.itemTypes();
   for (IntList::Iterator i = lst.begin(); i != lst.end(); ++i) {
      cmbType->insertItem(KObject::typeStr(*i));
      _typeList += *i;
   }
   cmbType->setCurrentItem(_typeList.findIndex(mngr.getDefaultType()));
}

void  KDlgManager1::initDialog()
{
   QBoxLayout *l = new QVBoxLayout(this, 8);

   QGroupBox *gbox = new QGroupBox(1, Horizontal, i18n("General"), this,
				   "Grb1");
   l->addWidget(gbox);

   //cbtGlobal= new QCheckBox(i18n("Use global settings"), gbox, "CbtGlobal");
   //connect(cbtGlobal, SIGNAL(toggled(bool)), this, SLOT(slotSetGlobal(bool)));

   QHBox * box = new QHBox(gbox);
   QLabel *lbl = new QLabel(i18n("Default Transfer Type"), box, "LblType");
   cmbType= new KComboBox(box, "CmbType");
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(cmbType, 1);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Priority Policy"), box, "LblPrPol");
   cmbPriority= new KComboBox(box, "cmbPriority");
   cmbPriority->insertItem(i18n("FIFO"));
   cmbPriority->insertItem(i18n("LIFO"));
   cmbPriority->insertItem(i18n("Short First"));
   cmbPriority->insertItem(i18n("Long First"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(cmbPriority, 0);

   cbtAutoDownload= new QCheckBox(gbox, "CbtAutoDownload");
   QToolTip::add(cbtAutoDownload,
		 i18n("Enable automatic downloading of transfers"));
   cbtAutoDownload->setText(i18n("Automatic downloading"));
  
   cbtRemoveCompleted= new QCheckBox(gbox, "CbtRemoveCompleted");
   QToolTip::add(cbtRemoveCompleted,
		 i18n("Automatic removing of completed transfers"));
   cbtRemoveCompleted->setText(i18n("Remove completed transfers"));

   gbox = new QGroupBox(1, Horizontal, i18n("Limits"), this, "Grb3");
   l->addWidget(gbox);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Max Open Transfers"), box,"LblMaxConn");
   lneMaxConn= new QLineEdit(box,"LneMaxConn");
   lneMaxConn->setFixedWidth(lneMaxConn->fontMetrics().width("XXXXX"));
   QToolTip::add(lneMaxConn,i18n("Maximum number of running transfers"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneMaxConn, 0);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Max Bandwidth (BPS)"), box,"LblMaxBand");
   lneMaxBand= new QLineEdit("XXXXXX", box, "LneMaxBand");
   lneMaxBand->setFixedWidth(lneMaxBand->fontMetrics().width("XXXXXXXX"));
   QToolTip::add(lneMaxBand,i18n("Maximum bandwidth allowed in BPS"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneMaxBand, 0);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Min Bandwidth (BPS)"), box,"LblMinBand");
   lneMinBand= new QLineEdit("XXXXXX", box, "LneMinBand");
   lneMinBand->setFixedWidth(lneMinBand->fontMetrics().width("XXXXXXXX"));
   QToolTip::add(lneMinBand,i18n("Minimum bandwidth allowed in BPS"));
   box->setStretchFactor(lbl, 1);
   box->setStretchFactor(lneMinBand, 0);

   //FIXME!! 3 column instead of 2???
#ifndef KURLREQ_ERR
#ifdef KDE_VERSION_POST_1207
   gbox = new QGroupBox(2, Horizontal, i18n("Directory & Files"), this, "Grb4");
#else
   gbox = new QGroupBox(3, Horizontal, i18n("Directory & Files"), this, "Grb4");
#endif
#else
   gbox = new QGroupBox(2, Horizontal, i18n("Directory & Files"), this, "Grb4");
#endif
   l->addWidget(gbox);

   lbl = new QLabel(i18n("Download Dir"), gbox, "lblDDir");

#ifndef KURLREQ_ERR
   cmbDDir = new KURLRequester(gbox, "CmbDDir");
#ifdef KDE_VERSION_POST_1207
   connect(cmbDDir, SIGNAL(openFileDialog(KURLRequester *)),
	   SLOT(slotOpenFileDialog(KURLRequester *)));
#else
   KFile::Mode mode = static_cast<KFile::Mode>(KFile::Directory|KFile::ExistingOnly | KFile::LocalOnly);
   cmbDDir->fileDialog()->setMode(mode);
   cmbDDir->fileDialog()->setKeepLocation(true);
#endif
   QToolTip::add(cmbDDir,i18n("Path of directory storing downloaded files"));
#else
   lneDDir = new QLineEdit(gbox, "LneDDir");
   QToolTip::add(lneDDir,i18n("Path of directory storing downloaded files"));
#endif

   lbl = new QLabel(i18n("Working Dir"), gbox, "lblWDir");

#ifndef KURLREQ_ERR
   cmbWDir = new KURLRequester(gbox, "CmbWDir");
#ifdef KDE_VERSION_POST_1207
   connect(cmbWDir, SIGNAL(openFileDialog(KURLRequester *)),
	   SLOT(slotOpenFileDialog(KURLRequester *)));
#else
   mode = static_cast<KFile::Mode>(KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly);
   cmbWDir->fileDialog()->setMode(mode);
   cmbWDir->fileDialog()->setKeepLocation(true);
#endif
   QToolTip::add(cmbWDir, i18n("Path of directory storing temporary files"));
#else
   lneWDir = new QLineEdit(gbox, "LneWDir");
   QToolTip::add(lneWDir,i18n("Path of directory storing temporary files"));
#endif

   lbl = new QLabel(i18n("Log File"), gbox, "lblLog");

#ifndef KURLREQ_ERR
   cmbLog = new KURLRequester(gbox, "CmbLog");
#ifdef KDE_VERSION_POST_1207
   connect(cmbLog, SIGNAL(openFileDialog(KURLRequester *)),
	   SLOT(slotOpenFileDialog(KURLRequester *)));
#else
   mode = static_cast<KFile::Mode>(KFile::File | KFile::LocalOnly);
   cmbLog->fileDialog()->setMode(mode);
   cmbLog->fileDialog()->setKeepLocation(true);
#endif
   QToolTip::add(cmbLog, i18n("Path of log file"));
#else
   lneLog = new QLineEdit(gbox, "LneLog");
   QToolTip::add(lneLog,i18n("Path of log file"));
#endif  

   adjustSize();
   setMinimumSize(size());
}

/** check if dialog is in an acceptable state */
bool KDlgManager1::isAcceptable()
{
   bool check;
   QString(lneMaxBand->text()).toInt(&check);
   if (!check)
      return false;
   QString(lneMinBand->text()).toInt(&check);
   if (!check)
      return false;
   QString(lneMaxConn->text()).toInt(&check);
   if (!check)
      return false;
#ifndef KURLREQ_ERR
   QFileInfo d(cmbDDir->url());
#else
   QFileInfo d(lneDDir->text());
#endif
   if (!d.exists() || !d.isDir())
      return false;
#ifndef KURLREQ_ERR
   d = cmbWDir->url();
#else
   d = lneWDir->text();
#endif
   if (!d.exists() || !d.isDir())
      return false;
   return true;
}

void KDlgManager1::slotSetGlobal(bool on)
{
   mngr.setGlobal(on);
   cbtAutoDownload->setEnabled(!on);
   cbtRemoveCompleted->setEnabled(!on);
   cmbPriority->setEnabled(!on);
   lneMaxBand->setEnabled(!on);
   lneMinBand->setEnabled(!on);
   lneMaxConn->setEnabled(!on);
#ifndef KURLREQ_ERR
   cmbDDir->setEnabled(!on);
   cmbWDir->setEnabled(!on);
   cmbLog->setEnabled(!on);
#else
   lneDDir->setEnabled(!on);
   lneWDir->setEnabled(!on);
   lneLog->setEnabled(!on);
#endif
   cmbType->setEnabled(!on);
   init();

   emit sigGlobalChange(on);
}

#ifndef KURLREQ_ERR
#ifdef KDE_VERSION_POST_1207
void KDlgManager1::slotOpenFileDialog(KURLRequester *kreq)
{
   KFile::Mode mode;
   if (kreq == cmbDDir || kreq == cmbWDir)
      mode = static_cast<KFile::Mode>(KFile::Directory|KFile::ExistingOnly 
				      | KFile::LocalOnly);
   else
      mode = static_cast<KFile::Mode>(KFile::File | KFile::LocalOnly);
   kreq->fileDialog()->setMode(mode);
   kreq->fileDialog()->setKeepLocation(true);
}
#endif   
#endif

#include "kdlgmanager1.moc"
