/***************************************************************************
                          kdlgopenmanager.cpp  -  description
                             -------------------
    begin                : Fri Sep 29 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.8 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtooltip.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include "kdlgopenmanager.h"

KDlgOpenManager::KDlgOpenManager(QWidget *parent, const char *name) 
   : KDialogBase(parent, name, true, i18n("New Manager"), Ok|Cancel) 
{
   _title = QString::null;
   initDialog();
}

KDlgOpenManager::~KDlgOpenManager()
{
}

void  KDlgOpenManager::initDialog()
{
   QWidget *page = new QWidget(this);
   setMainWidget(page);
  
   QBoxLayout *l = new QVBoxLayout(page, 8);

   QGroupBox *gbox = new QGroupBox(1, Horizontal, page);
   l->addWidget(gbox);

   new QLabel(i18n("Manager Title"), gbox, "LblTitle");
   lneTitle = new QLineEdit(gbox, "LneTitle");
}

QString KDlgOpenManager::exec() 
{
   if (QDialog::exec() == Accepted) 
      return _title; 
   else 
      return QString::null;
}

void KDlgOpenManager::slotOk() 
{
   _title = lneTitle->text();
   KDialogBase::slotOk();
}

#include "kdlgopenmanager.moc"
