/***************************************************************************
                          kobject.h  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.13 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KOBJECT_H
#define KOBJECT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdom.h>
#include <qguardedptr.h>
#include "km.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif


using namespace KM;

class KCntIterator;
class KObjectImpl;
class KMManagerImpl;
class KContainer;
class KRootContainer;
class KTManager;
class KMManager;
class KTransfer;
#ifdef ENABLE_WGET
class KTransferWget;
#endif
#ifdef ENABLE_KIO
class KTransferKio;
#endif

/** 
 * @short Bridge class for @ref KObjectImpl 
 *
 * @author Sergio Moretti
 *
 * @version $Id: kobject.h,v 1.13 2001/03/22 09:26:52 sergio Exp $
 */
class KObject 
{
   friend class KCntIterator;
   friend class KObjectImpl;
   friend class KRootContainerImpl;
   friend class KTransfer;
#ifdef ENABLE_WGET
   friend class KTransferWget;
#endif
#ifdef ENABLE_KIO
   friend class KTransferKio;
#endif
   friend class KRootContainer;
   friend class KContainer;
   friend class KTManager;
   friend class KMManager;

public:
   typedef QValueList<KObject> List;

   /** constructor */
   KObject() : _impl() {}
   /** object is null */
   bool isNull() const { return _impl.isNull(); }
   void setNull() { _impl = QGuardedPtr<KObjectImpl>(); }
   /** identity of object */
   int id() const;
   /** string identifier of object */
   const char * name() const;
   /** parent container */
   KContainer container() const;
   KRootContainer root() const;
   int type() const;
   QDomElement dom() const;
   const ModFlags & modState() const;
   bool useGlobal() const;
   bool getGlobal() const;
   void setGlobal(bool g) const;
   bool isGlobal() const;
   bool isRoot() const;
   bool isDefault() const;
   bool isNormal() const;
   void start() const;
   void kill(bool wait = false) const;
   bool isRunning() const;
   void runPeriodically() const;
   int priority() const;
   int prioritySum() const;
   void setPriority(int p) const;
   QString message() const;
   void setMessage(const QString &msg) const;
   bool isMod(ModIndex p) const;
   bool isMods(const ModFlags &f) const;
   void resetMods() const;
   void emitMod() const;
   QString modString() const;

   /** destroy implementation instance */
   void deleteInstance();
   /** connect object's signal to slots */
   bool connect(const char *signal, const QObject *receiver, 
		const char *member) const;
   /** conversions */
   QObject * toQObject() const;
   KRootContainer toRootContainer() const;
   KContainer toContainer() const;
   KTransfer toTransfer() const;
   KTManager toTManager() const;
   KMManager toMManager() const;
#ifdef ENABLE_WGET
   KTransferWget toTransferWget() const;
#endif
#ifdef ENABLE_KIO
   KTransferKio toTransferKio() const;
#endif

   bool operator==(const KObject &o) const { return impl() == o.impl(); }
   bool operator!=(const KObject &o) const { return impl() != o.impl(); }

   static KObject null() { return KObject(); }
   static QString typeStr(int type);
   static void initFactory();
   static void deleteFactory();

protected:
   KObject(KObjectImpl *impl);
   KObjectImpl * impl() const { return _impl; }

private:
   QGuardedPtr<KObjectImpl> _impl;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
