/***************************************************************************
                          ktransferwgetimpl.h  -  description
                             -------------------
    begin                : Thu Oct 19 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.13 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSFERWGETIMPL_H
#define KTRANSFERWGETIMPL_H

#ifndef HAVE_SETENV
int setenv(const char *name, const char *value, int overwrite);
#endif

#ifndef HAVE_UNSETENV
int unsetenv(const char * name);
#endif

#include <sys/types.h>
#include <regex.h>
#include <kurl.h>
#include <kprocess.h>
//#include "ktransferwget.h"
#include "ktransferimpl.h"

class KTransferWget;

/**
 * @short Concrete implementation of transfer based on wget executable.
 * 
 * @author Sergio Moretti
 *
 * @version $Id: ktransferwgetimpl.h,v 1.13 2001/03/22 09:26:52 sergio Exp $
 */

class KTransferWgetImpl : public KTransferImpl  
{
   Q_OBJECT
   
   friend class KTransferWget;
   friend class KObject;
   
   /** symbol to index regular expression string */
   enum REId 
   {
      RE_INT = 0,
      RE_CNN,
      RE_FTP_LOGIN,
      RE_FTP_TYPE,
      RE_FTP_CWD,
      RE_FTP_PORT,
      RE_FTP_PASV,
      RE_FTP_LIST,
      RE_FTP_REST,
      RE_FTP_REST_ACK,
      RE_FTP_RETR,
      RE_FTP_LENGTH,
      RE_DWN,
      RE_DW1,
      RE_DW2,
      RE_DW3,
      RE_FTP_DW4,
      RE_FTP_ACK,
      RE_ACKERR,
      RE_HTTP_REQUEST,
      RE_HTTP_AUTHFAIL,
      RE_HTTP_LOCATION,
      RE_HTTP_LENGTH,
      RE_HTTP_DW4,
      RE_HTTP_ACK,
    
      RE_NUM
   };

   /** local status for ftp connections */
   enum LocalFTPStatus 
   {
      FTP_DISCONNECT = 0,
      FTP_CONNECT_REQ,
      FTP_CONNECT_ACK,
      FTP_LOGIN_REQ,
      FTP_LOGIN_ACK,
      FTP_TYPE_REQ,
      FTP_TYPE_ACK,
      FTP_CWD_REQ,
      FTP_CWD_ACK,
      FTP_PORT_REQ,
      FTP_PORT_ACK,  // 10
      FTP_PASV_REQ,
      FTP_PASV_ACK,
      FTP_DUMMY1,
      FTP_LIST_REQ,
      FTP_LIST_ACK,
      FTP_REST_REQ,
      FTP_REST_ACK,
      FTP_RETR_REQ,
      FTP_RETR_ACK,
      FTP_LENGTH, // 20
      FTP_DOWNLOAD_START,
      FTP_DOWNLOAD_RUN,
      FTP_DOWNLOAD_END,
    
      FTP_NUMSTATE
   };

   /** local status for http connections */
   enum LocalHTTPStatus 
   {
      HTTP_DISCONNECT = 0,
      HTTP_CONNECT_REQ,
      HTTP_CONNECT_ACK,
      HTTP_REQUEST_REQ,
      HTTP_REQUEST_ACK,
      HTTP_LENGTH,
      HTTP_DOWNLOAD_START,
      HTTP_DOWNLOAD_RUN,
      HTTP_DOWNLOAD_END,

      HTTP_NUMSTATE
   };

   // error types
   enum LocalError 
   {
      ERR_OK = 0,
      ERR_RETRY,
      ERR_GIVEUP,
      ERR_ABORT
   };

   // result of matching function
   enum Match 
   {
      MTC_CONT,
      MTC_FAIL,
      MTC_OK
   };
  
   /**  Regular expression strings */
   static const char RE_STR[RE_NUM][300];
  
public:
   /** calculate the temporary file */
   virtual KURL getTempFile(const KURL &rmt, const KURL &lcl) const;

   virtual bool isRunning() const;

   virtual bool isProtocolSupported(const QString &proto) const;
  
   // config attributes

   /** get wget command path */
   QString getCmdPath() const;
   /** set wget command path */
   void setCmdPath(const QString &c);
   /** use passive transfer mode */
   bool getPassiveFtp() const;
   /** set passive transfer mode */
   void setPassiveFtp(bool p);
   int getReadTimeout() const;
   void setReadTimeout(int t);
   bool getHTTPCache() const;
   void setHTTPCache(bool m);
   bool getProxy() const;
   void setProxy(bool m);
   QString getProxyFTP() const;
   void setProxyFTP(const QString &p);
   QString getProxyHTTP() const;
   void setProxyHTTP(const QString &p);
   int getProxyPortFTP() const;
   void setProxyPortFTP(int p);
   int getProxyPortHTTP() const;
   void setProxyPortHTTP(int p);
   const QStringList & getNoProxyList() const;
   void setNoProxyList(const QStringList &l);
   TransferSpeed getSpeed() const;
   void setSpeed(TransferSpeed s);
   bool getIgnoreLength() const;
   void setIgnoreLength(bool v);
  
protected:
   /** create empty transfer */
   KTransferWgetImpl(int type);

   /** clone operation */
   virtual KObjectImpl* clone() const;

   virtual void loadData();

   const KTransferWgetImpl * global() const;

   /** parse the ftp retrieve output */
   virtual void parseFTP();

   /** parse the http retrieve output */
   virtual void parseHTTP();

   QString matchStr(int i) const;

   Match parseToken(REId token, int nextState, int failState = 0);

   Match parseProlog(int nextState);

   Match parseAck(REId token, int nextState);

   Match parseCwd();

   Match parseRest();

   Match parseRestAck();

   Match parseFtpLength();

   Match parseDownloadStart(int nextState);

   Match parseDownloadRun();

   Match parseFtpDownloadEnd();

   void parseExit();

   Match parseLocation();

   Match parseHttpLength();

   Match parseHttpDownloadEnd();

   QString getWgetVersion();

   /** compile regexps */
   static void initRE();

   // define abstract methods

   virtual bool processStart();

   virtual bool processKill();

   virtual void processCheckResumeBegin();

   virtual void processCheckResumeEnd();

protected slots:
   void slotProcessOutput(KProcess *, char *buffer, int buflen);

   void slotProcessExited(KProcess *);

private:
   // state
   static regex_t _preg[RE_NUM];
   static bool _reInit;
   /** process */
   KProcess process;
   /** buffer */
   QCString _parsebuf;
   /** true if a resuming transfer is starting */
   bool _tryResuming;
   /** local status */
   int _localStatus;
   /** protocol used for transfer */
   int _protocol;
   /** error status */
   int _localError;
   /** dot block dimension */
   int _block;
   /** flag to signal process ending */
   bool _processExit;
   /** flag to signal that you are downloading a directory */
   bool _directory;
   /** result of regex */
   regmatch_t _pmatch[10];
   /** function pointer to parse routine */
   void (KTransferWgetImpl::*_parseCmd)();
   /** partial saved for restoring from checkResume */
   int _oldPartial;

   // conf
   /** cmdpath of wget */
   QString _cfg_cmdPath;
   /** use passive transfer mode */
   bool _cfg_passiveFtp;
   /**(dis)allow HTTP server-cached data */
   bool _cfg_HTTPCache;
   /** enable proxy */
   bool _cfg_proxy;
   /** read timeout */
   int _cfg_readTimeout;
   /** HTTP proxy */
   QString _cfg_proxyHTTP;
   /** FTP proxy */
   QString _cfg_proxyFTP;
   /** HTTP proxy port */
   int _cfg_proxyPortHTTP;
   /** FTP proxy port */
   int _cfg_proxyPortFTP;
   /** list of no-proxy hosts */
   QStringList _cfg_noProxy;
   /** transfer speed */
   TransferSpeed _cfg_speed;
   /** ignore Content-Length */
   bool _cfg_ignoreLen;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
