/***************************************************************************
                          chatviewimpl.cpp  -  description
                             -------------------
    begin                : Wed Jul 4 2001
    copyright            : (C) 2001 by olaf lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// my include
#include "chatviewimpl.h"

// kde
#include <klocale.h>
#include <kdebug.h>
#include <ktextbrowser.h>
#include <kstddirs.h>
#include <knotifyclient.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kmessagebox.h>

// qt
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qregexp.h>


// Thanks to Gorka Olaizola for the smiley patch


ChatViewImpl::ChatViewImpl(QWidget *parent, const char *name ) : chatview(parent,name)
{
	int i =0;
	smilies[i++]=new Smiley(":-\\)", ":-)", "regular" );
	smilies[i++]=new Smiley(":-\\(", ":-(", "sad" );
	smilies[i++]=new Smiley(";-\\)",";-)" , "wink" );
	smilies[i++]=new Smiley(":o"   ,":o"   , "omg" );
	smilies[i++]=new Smiley(":D"   ,":D"   , "teeth" );
	smilies[i++]=new Smiley(":p"   ,":p"   , "tounge" );
	smilies[i++]= new Smiley(":s"   ,":s"   , "confused" );
	smilies[i++]=new Smiley(":\\|" ,":|" , "whatchutalkingabout" );
	smilies[i++]=new Smiley(":'\\(",":'(", "cry" );
	smilies[i++]=new Smiley(":-\\$",":-$", "embaressed" );
	smilies[i++]=new Smiley("\\(H\\)","(H)", "shades" );
	smilies[i++]=new Smiley(":-@"      ,":-@", "angry" );
	smilies[i++]=new Smiley("\\(A\\)"  ,"(A)", "angel" );
	smilies[i++]=new Smiley("\\(6\\)"  ,"(6)", "devil" );
	smilies[i++]=new Smiley("\\(I\\)"  ,"(I)", "lightbulb" );
	smilies[i++]= new Smiley("\\(Y\\)"  ,"(Y)", "thumbs_up");
	smilies[i++]=new Smiley("\\(N\\)"  ,"(N)", "thumbs_down" );
	smilies[i++]=new Smiley("\\(B\\)"  ,"(B)", "beer" );
	smilies[i++]=new Smiley("\\(D\\)"  ,"(D)", "martini" );
	smilies[i++]=new Smiley("\\(X\\)"  ,"(X)", "girl" );
	smilies[i++]=new Smiley("\\(Z\\)"  ,"(Z)", "boy" );
	smilies[i++]=new Smiley("\\(\\{\\)","({)", "dude_hug" );
	smilies[i++]=new Smiley("\\(\\}\\)","(})", "girl_hug" );
	smilies[i++]=new Smiley(":-\\[",":-[", "bat" );
	smilies[i++]=new Smiley("\\(L\\)"  ,"(L)", "heart" );
	smilies[i++]=new Smiley("\\(U\\)"  ,"(U)", "broken_heart" );
	smilies[i++]=new Smiley("\\(K\\)"  ,"(K)", "kiss" );
	smilies[i++]=new Smiley("\\(G\\)"  ,"(G)", "present" );
	smilies[i++]=new Smiley("\\(F\\)"  ,"(F)", "rose" );
	smilies[i++]=new Smiley("\\(W\\)"  ,"(W)", "wilted_rose" );
	smilies[i++]=new Smiley("\\(P\\)"  ,"(P)", "camera" );
	smilies[i++]=new Smiley("\\(T\\)"  ,"(T)", "phone" );
	smilies[i++]=new Smiley("\\(@\\)"  ,"(@)", "kittykay" );
	smilies[i++]=new Smiley("\\(&\\)"  ,"(&)", "bowwow" );
	smilies[i++]=new Smiley("\\(C\\)"  ,"(C)", "cup" );
	smilies[i++]=new Smiley("\\(s\\)"  ,"(s)", "moon" );
	smilies[i++]=new Smiley("\\(\\*\\)", "(*)","star" );
	smilies[i++]=new Smiley("\\(8\\)", "(8)","musical_note" );
	smilies[i++]=new Smiley("\\(E\\)"  ,"(E)", "envelope" );
	smilies[i++]=new Smiley("\\(o\\)"  ,"(o)", "clock" );
	smilies[i++]=new Smiley("\\(M\\)"  ,"(M)", "messenger" );
	smilies[i++]=new Smiley("\\(y\\)"  ,"(y)", "thumbs_up" );
	smilies[i++]=new Smiley("\\(n\\)"  ,"(n)", "thumbs_down" );
	smilies[i++]=new Smiley("\\(b\\)"  ,"(b)", "beer" );
	smilies[i++]=new Smiley("\\(d\\)"  ,"(d)", "martini" );
	smilies[i++]=new Smiley("\\(x\\)"  ,"(x)", "girl" );
	smilies[i++]=new Smiley("\\(z\\)"  ,"(z)", "boy" );
	smilies[i++]=new Smiley(":\\[" ,":[" , "bat" );
	smilies[i++]=new Smiley(":\\)" , ":)" , "regular" );
	smilies[i++]=new Smiley(":\\(" , ":(" , "sad" );
	smilies[i++]=new Smiley(":<"   , ":<" , "sad" );
	smilies[i++]=new Smiley(":-<"  , ":-<", "sad" );
	smilies[i++]=new Smiley(";\\)" ,";)"  , "wink" );
	smilies[i++]=new Smiley(":O"   ,":O"   , "omg" );
	smilies[i++]=new Smiley(":-o"  ,":-o"  , "omg" );
	smilies[i++]=new Smiley(":-O"  ,":-O"  , "omg" );
	smilies[i++]=new Smiley(":d"   ,":d"   , "teeth" );
	smilies[i++]=new Smiley(":-D"  ,":-D"  , "teeth" );
	smilies[i++]=new Smiley(":-d"  ,":-d"  , "teeth" );
	smilies[i++]=new Smiley(":>"   ,":>"   , "teeth" );
	smilies[i++]=new Smiley(":->"  ,":->"  , "teeth" );
	smilies[i++]=new Smiley(":P"   ,":P"   , "tounge" );
	smilies[i++]=new Smiley(":-p"  ,":-p"  , "tounge" );
	smilies[i++]=new Smiley(":-P"  ,":-P"  , "tounge" );
	smilies[i++]=new Smiley(":S"   ,":S"   , "confused" );
	smilies[i++]=new Smiley(":-s"  ,":-s"  , "confused" );
	smilies[i++]=new Smiley(":-S"  ,":-S"  , "confused" ) ;
	smilies[i++]=new Smiley(":-\\|",":-|", "whatchutalkingabout" );
	smilies[i++]=new Smiley(":\\$" ,":$" , "embaressed" );
	smilies[i++]=new Smiley("\\(h\\)"  ,"(h)", "shades" );
	smilies[i++]=new Smiley(":@"       ,":@" , "angry" );
	smilies[i++]=new Smiley("\\(a\\)"  ,"(a)", "angel" );
	smilies[i++]=new Smiley("\\(l\\)"  ,"(l)", "heart" );
	smilies[i++]=new Smiley("\\(u\\)"  ,"(u)", "broken_heart" );
	smilies[i++]=new Smiley("\\(k\\)"  ,"(k)", "kiss" );
	smilies[i++]=new Smiley("\\(g\\)"  ,"(g)", "present" );
	smilies[i++]=new Smiley("\\(f\\)"  ,"(f)", "rose" );
	smilies[i++]=new Smiley("\\(w\\)"  ,"(w)", "wilted_rose" );
	smilies[i++]=new Smiley("\\(p\\)"  ,"(p)", "camera" );
	smilies[i++]=new Smiley("\\(t\\)"  ,"(t)", "phone" );
	smilies[i++]=new Smiley("\\(c\\)"  ,"(c)", "cup" ),
	smilies[i++]=new Smiley("\\(i\\)"  ,"(i)", "lightbulb" );
	smilies[i++]=new Smiley("\\(S\\)"  ,"(S)", "moon" );
	smilies[i++]=new Smiley("\\(e\\)"  ,"(e)", "envelope" );
	smilies[i++]=new Smiley("\\(^\\)"  ,"(^)", "cake" );
	smilies[i++]=new Smiley("\\(O\\)"  ,"(O)", "clock" );
	smilies[i++]=new Smiley("\\(m\\)"  ,"(m)", "messenger" );
	loadSmileys("kmerlin/smilies/");
	viewSmileys = true;
	textChanged = false;
	infoText->setText(i18n("Please wait"));
	SendButton->setAccel(CTRL+Key_Return);
}
ChatViewImpl::~ChatViewImpl()
{
	for (int i=0;i<NUMSMILIES;i++)
	{
		delete smilies[i];
	}

}

// Send button clicked
void ChatViewImpl::sendText()
{
	QString text = strSend->text();
	if(!text.isEmpty())
	{
		if(text.length() >400)
		{
			KMessageBox::error(0,"Your message is too long!\nYou canot use more than 400 characters.");
			return;
		}
		else
		{
			for(int i =0; i < text.length(); i++)
			{
				if(text.at(i) == '\n' && text.at(i+1) == '\n')
				{
					text.replace(i,1," ");
				}
			}
			text = text.replace(QRegExp("\n"),"\r\n"); 
			
			emit sendMsg(text);//.utf8());
			strSend->setText("");
			textChanged = false;
		}
	}
}

QString ChatViewImpl::htmlParser(QString message){
  message = message.replace(QRegExp("<"),"&lt;");
  message = message.replace(QRegExp(">"),"&gt;");
  return message;
}

QString ChatViewImpl::urlParser(QString message,QString tag )
{
  // if viewSmileys=true  urlParser works not correctly
  QChar c;
  c=message.at(0);
  while (c == '\n' || c == '\r' || c == '\0')
 {
   message.remove(0,1);  //removes prefixing \n \r and \0 so this function can work
   c=message.at(0);
 }

  int i = message.find(tag);

  redo:
  QString str= "";
  if(i != -1){
   	if(i == 0){
  	 	message.insert(i,"<a href=\"");
  	 	i = 1;
  	}
  	else{
  		if(QString(message.at(i-1)) == " "){
  			message.insert(i,"<a href=\"");
  			i = i+1;
  			
  		}
  		else{
  			kdDebug() << " no valid url" << endl;
  			goto nodata;
  		}
  	}
  	 i = i+8;

 	 do{
 	 	  str += message.at(i);
 	 	  i++;
 	 }
 	 while((c= message.at(i)) != " " & i != message.length());
 	 message.insert(i,"\">" +str +"</a>");
  }
  nodata:
  if( i != -1){

  	i = message.find(tag,i+str.length()+1);
  	if(i != -1){
  		goto redo;
  	}
  }
	return message;
}
	
/** No descriptions */
void ChatViewImpl::insertMessage(QString publicName,QString message){
	if(!isActiveWindow()){
		KNotifyClient::event("message",publicName+": "+message);
	}
  message = htmlParser(message);
  message = urlParser(message,"http:");
  message = urlParser(message,"mailto:");
  message = urlParser(message,"ftp:");
  publicName = publicName.replace(QRegExp("<"),"&lt;");
  publicName = publicName.replace(QRegExp(">"),"&gt;");

  if(viewSmileys){
  	message = smileyParser(message);
  }
	message = message.replace(QRegExp("\r\n"),"<br>");
 	TextBrowser->setText(TextBrowser->text()+"<font color=blue size=\"+1\">"+publicName+" "+i18n("says:")+"</font>"+"<br>"+
 	"<font >"+message+"</font><br>");
	TextBrowser->scrollBy(0,TextBrowser->contentsHeight());
	TextBrowser->repaintContents(0,0,TextBrowser->contentsWidth(),TextBrowser->contentsHeight(),true);
}
/** No descriptions */

QString ChatViewImpl::smileyParser(QString message)
{
	int i;
	for (i=0;i<NUMSMILIES;i++)
	{
		message = message.replace(QRegExp(smilies[i]->regExp),"<img src=\""+smilies[i]->filename+"\">");
	}
	return message;
}


/** No descriptions */
void ChatViewImpl::loadSmileys(QString smiliesdir){
	KStandardDirs dir;
	KConfig *config = new KConfig(dir.findResource("data",smiliesdir+"smileyrc"));
	config->setGroup("Default");
	
	int i;
	QString strtmp;
	for (i=0;i<NUMSMILIES;i++) {
		strtmp = smiliesdir + config->readEntry(smilies[i]->filename);
		smilies[i]->filename = dir.findResource("data", strtmp);
	}
	KIconLoader load;	
	PixmapLabel1->setPixmap(load.loadIcon("idea.png",KIcon::Toolbar));
	delete config;
}
/** No descriptions */
void ChatViewImpl::slotTextChanged()
{

	QString str = strSend->text();
    if(strSend->text().isEmpty() || strSend->text() == "\n" )
    {
        SendButton->setEnabled(false);
        textChanged = false;
    }
    else
    {
        SendButton->setEnabled(true);
        textChanged = true;
    }
    if(strSend->text().length() == 1) // typing has start
    {
        emit writeMessage();
    }
}

/** No descriptions */
void ChatViewImpl::slotUrlClicked(const QString& url){
}
/** No descriptions */
void ChatViewImpl::systemMessage(QString message){
	KStandardDirs dir;
	TextBrowser->setText(TextBrowser->text()+"<font face=\""+fontName+"\"size=\"+1\">---------------------------<br></font><font face=\""+fontName+"\" color=red size=+1><img src=\""+ dir.findResource("data","kmerlin/pics/kong.png")+"\" align=center>"+message+"</font><font face=\""+fontName+"\"size=\"+1\"><br>---------------------------<br></font>");
	TextBrowser->scrollBy(0,TextBrowser->contentsHeight());
	TextBrowser->repaintContents(0,0,TextBrowser->contentsWidth(),TextBrowser->contentsHeight(),true);
}

// Speed up compilation
#include "chatviewimpl.moc"


