/*

Copyright, 2001 Niels Reedijk
This file is licensed under the GNU GPL version 2, as can be found in the
COPYING file in this source package.

*/

#ifndef KMSNACTION
#define KMSNACTION

#include <kaction.h>


//This class defines a custom KAction: one that sends its ID to the slot
//connected to it...
class KMsnAction : public KAction
{
  Q_OBJECT
public:
  KMsnAction( const QString& text,     //the text to be displayed in menu
                  int accel ,           //an accel
                  const QObject *receiver, //the receiver of the slot
                  const char *slot,        //the slot (needs to accept a QString
                  QObject *parent,         //the parent...
                  QString name ,           //and the name
                  short int id);
signals:
  void activated( int id );
protected slots:
  //Inherit from KAction...
  void slotActivated();
protected:
  short int actionID;
};

#endif
