/***************************************************************************
                          mylistview.cpp  -  description
                             -------------------
    begin                : Thu Jun 21 2001
    copyright            : (C) 2001 by olaf lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mylistview.h"
#include <qheader.h>
#include <qtooltip.h>
#include <kcursor.h>


MyListView::MyListView(QWidget *parent, const char *name ) : QListView(parent,name) {
	column = 0; 						// Display column as Tooltip
	header()->hide();       // disable ColumnHeader
	addColumn("Column",-1);	// create standart column
	QToolTip::setEnabled(true); // enable Tooltips

	setVScrollBarMode( QListView::Auto );
  setHScrollBarMode( QListView::AlwaysOff );
  setRootIsDecorated( false );
  setLineWidth(0);						// no border

	//connections
	connect(this,SIGNAL(onItem(QListViewItem*)),this,SLOT(slotOnItem(QListViewItem*)));
	connect(this,SIGNAL(onViewport()),this,SLOT(viewPort()));
	  // palette for listview
	  QPalette pal;
    QColorGroup cg;
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 237, 237, 237) );
    cg.setColor( QColorGroup::Dark, QColor( 110, 110, 110) );
    cg.setColor( QColorGroup::Mid, QColor( 146, 146, 146) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 220, 217, 220) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 253, 253, 253) );
    cg.setColor( QColorGroup::Dark, QColor( 110, 110, 110) );
    cg.setColor( QColorGroup::Mid, QColor( 146, 146, 146) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 220, 217, 220) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 253, 253, 253) );
    cg.setColor( QColorGroup::Dark, QColor( 110, 110, 110) );
    cg.setColor( QColorGroup::Mid, QColor( 146, 146, 146) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, white );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 220, 220, 220) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 220, 217, 220) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setDisabled( cg );
 //   setPalette(pal);
}
MyListView::~MyListView(){
}
/**Display the Tooltip */
void MyListView::slotOnItem(QListViewItem* item){
	setCursor(KCursor::handCursor());
	QToolTip::setEnabled(true); // enable Tooltips
	QToolTip::remove(this);
	QToolTip::add(this,item->text(column));
}

/** delete tooltip and restore cursor */
void MyListView::viewPort(){
	QToolTip::remove(this);
		setCursor(KCursor::arrowCursor());
}


/** No descriptions */
void MyListView::setTooltipColumn(int i){
	column = i;
}

#include "mylistview.moc"

