/***************************************************************************
                          onlineview.cpp  -  description
                             -------------------
    begin                : Fri Jun 22 2001
    copyright            : (C) 2001 by olaf lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Must be included before idle.h since X11 declares an Accept define. /hpj
#include <qtoolbar.h>

// my own
#include "onlineview.h"
#include "imservice.h"
#include "mylistview.h"
#include "adduserimpl.h"
#include "idle.h"
#include "kmsnapp.h"

// qt
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qsizepolicy.h>
#include <qstringlist.h>
#include <qregexp.h>
//kde
#include <kpopupmenu.h>
#include <klocale.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kmainwindow.h>
#include <kapp.h>
#include <kurllabel.h>
#include <kdebug.h>
#include <krun.h>

OnlineView::OnlineView(QWidget *parent, const char *name ) : QWidget(parent,name) {
	setBackgroundMode(PaletteBase);
	setGeometry(0,0,250,300);
	loadIcons();
	QVBoxLayout *layout=new QVBoxLayout(this);
	layout->setSpacing(0);
	layout->setMargin(4);
	QHBoxLayout *hbox=new QHBoxLayout(layout);
	mailLabel = new KURLLabel(this);
	mailLabel->setBackgroundMode(PaletteBase);
	mailLabel->setText(i18n("You have no E-Mails"));
	mailLabel->setURL(i18n("Click here to open Hotmail"));
	mailLabel->setUseTips(true);
	//create the mailPixmap
	mailLabelPixmap =  new QLabel(this);
	mailLabelPixmap->setPixmap(Pixmap1);
	mailLabelPixmap->setBackgroundMode(PaletteBase);
	mailLabelPixmap->setSizePolicy(QSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum));
	hbox->addWidget(mailLabelPixmap);
	hbox->addWidget(mailLabel);
	//create the onlinePixmap
	onlineLabelPixmap =  new QLabel(this);
	onlineLabelPixmap->setPixmap(Pixmap2);
	onlineLabelPixmap->setBackgroundMode(PaletteBase);
	onlineLabelPixmap->setSizePolicy(QSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum));
	//create the onlineLabel
	onlineLabel = new KURLLabel(this);
	onlineLabel->setBackgroundMode(PaletteBase);
	onlineLabel->setText("Offline");
	onlineLabel->setURL(i18n("Click here to change your Online state"));
	onlineLabel->setUseTips(true);
	hbox=new QHBoxLayout(layout);
	hbox->addWidget(onlineLabelPixmap);
	hbox->addWidget(onlineLabel);
	// connection for labels
	connect(mailLabel, SIGNAL(leftClickedURL(const QString&)),SLOT(processMailURL(const QString&)));
	connect(onlineLabel, SIGNAL(leftClickedURL(const QString&)),SLOT(processOnlineURL(const QString&)));

	layout->addSpacing(5);

	// create the ListView
	// an item has now 3 columns publicName+(Status),Handle,Sort - display's online at first
	// one visible column
	ListView = new MyListView(this);
	ListView->setBackgroundMode(PaletteBase);
	ListView->setTooltipColumn(1);        // e-mail for tooltip
	ListView->setSorting(2,true);	      // display Online Item at first
	layout->addWidget(ListView,3);

	// connection for ListView
	connect( ListView, SIGNAL( expanded(QListViewItem*) ), this, SLOT( slotExpanded(QListViewItem*) ) );
	connect( ListView, SIGNAL( collapsed(QListViewItem*) ), this, SLOT( slotCollapsed(QListViewItem*) ) );
	connect( ListView, SIGNAL( rightButtonClicked(QListViewItem*,const QPoint&,int) ), this, SLOT( slotRightClick(QListViewItem*,const QPoint&,int) ) );
	connect( ListView,SIGNAL(doubleClicked(QListViewItem*)),this,SLOT(slotDbClicked(QListViewItem*)));
	
	connect(ListView, SIGNAL(selectionChanged ( QListViewItem * )), this, SLOT(slotSelectionChanged(QListViewItem*)));
	// create the mail label

	setCaption(i18n("Not Connected"));

}
OnlineView::~OnlineView()
{
}

bool OnlineView::isEmpty()
{
	if(ListView->currentItem()->childCount() == 0)
	{
		return true;
	}
	else
	return false;
}

QString OnlineView::getParent()
{
	if( ListView->currentItem() == 0 ) return 0L;
	if(ListView->currentItem()->parent() != 0)
	{
		return ListView->currentItem()->parent()->text(0);
	}
	else
	{
		return 0L;
	}
}

QString OnlineView::getGroup()
{
	if( ListView->currentItem() == 0 ) return 0L;
	if(ListView->currentItem()->parent() != 0)
	{
		return ListView->currentItem()->parent()->text(0);
	}
	else
	{
		return ListView->currentItem()->text(0);
	}
}

QString OnlineView::getHandle()
{
	if( ListView->currentItem() == 0 ) return 0L;
	if(ListView->currentItem()->parent() != 0)
	{
		return ListView->currentItem()->text(1);
	}
	else
	{
		return 0L;
	}
}


void OnlineView::slotConnected(bool f)
{
	QStringList groups, contacts;
	QString group;
	uint status;
	QListViewItem *item, *item1;
	if( f )
	{
		groups = theApp->imService->getGroups();
		for ( QStringList::Iterator it = groups.begin(); it != groups.end(); ++it )
		 {
			item=  new QListViewItem(ListView,(*it).latin1() ,"","1");
			item->setPixmap(0,expandedPixmap);
			item->setOpen(true);
			contacts = theApp->imService->getContacts( (*it).latin1() );
			for ( QStringList::Iterator it1 = contacts.begin(); it1 != contacts.end(); ++it1 )
		 	{
		 		item1= new QListViewItem(item, theApp->imService->getPublicName((*it1).latin1())  , (*it1).latin1() ,"1");
		 		status = theApp->imService->getStatus( (*it1).latin1() );
		 		switch(status)
				{
				case NLN:
				{
					item1->setText(0, theApp->imService->getPublicName( (*it1).latin1()) );
					item1->setPixmap(0, onlinePixmap );
					break;
				}
				case FLN:
				{
					item1->setText(0, theApp->imService->getPublicName( (*it1).latin1()) );
					item1->setPixmap(0, offlinePixmap );
					break;
				}
				case BSY:
				{
					item1->setText(0, theApp->imService->getPublicName( (*it1).latin1()) + " ( " + i18n("Busy") + " )" );
					item1->setPixmap(0, awayPixmap );
					break;
				}
				case IDL:
				{
					item1->setText(0, theApp->imService->getPublicName( (*it1).latin1()) + " ( " + i18n("Away") + " )" );
					item1->setPixmap(0, awayPixmap );
					break;
				}
				case AWY:
				{
					item1->setText(0, theApp->imService->getPublicName( (*it1).latin1()) + " ( " + i18n("Away") + " )");
					item1->setPixmap(0, awayPixmap );
					break;
				}
				case PHN:
				{
					item1->setText(0, theApp->imService->getPublicName( (*it1).latin1()) + " ( " + i18n("On the phone") + " )");
					item1->setPixmap(0, awayPixmap );
					break;
				}
				case BRB:
				{
					item1->setText(0, theApp->imService->getPublicName( (*it1).latin1()) + " ( " + i18n("Be right back") + " )");
					item1->setPixmap(0, awayPixmap );
					break;
				}
				case LUN:
				{
					item1->setText(0, theApp->imService->getPublicName( (*it1).latin1()) + " ( " + i18n("Out to lunch") + " )");
					item1->setPixmap(0, awayPixmap );
					break;
				}
				}
		 		if( theApp->imService->isBlocked( (*it1).latin1()) )
		 		{
		 			item1->setText(0,  theApp->imService->getPublicName((*it1).latin1()) + i18n(" Blocked") );
		 			item1->setPixmap(0, blockedPixmap);
		 		}
		 		
		 	}
		}
	}
	else
	{
		ListView->clear();
	}
}

void OnlineView::slotUpdateGroup(QString oldGroup, QString newGroup)
{
	theApp->stopWorkTimer();
	QListViewItemIterator it( ListView );
	for ( ; it.current(); ++it )
	{
		if( it.current()->text(0) == oldGroup  )
		{
			if( it.current()->parent() == 0)
			{
				it.current()->setText(0,newGroup);
			}
		}
	}
}

void OnlineView::slotRemoveGroup( QString groupName)
{
	theApp->stopWorkTimer();
	QListViewItemIterator it( ListView );
	for ( ; it.current(); ++it )
	{
		if( it.current()->text(0) == groupName  )
		{
			if( it.current()->parent() == 0)
			{
				delete it.current();
				return;
			}
		}
	}
}
void OnlineView::slotInsertGroup( QString groupName )
{
	theApp->stopWorkTimer();
	QListViewItem *item = new QListViewItem(ListView, groupName, "", "1" );
	item->setPixmap(0,expandedPixmap);
	item->setOpen(true);
}

void OnlineView::slotUpdateContact(QString handle, uint status )
{
	theApp->stopWorkTimer();
	QListViewItemIterator it( ListView );
	QListViewItem *item;
	if( theApp->imService->isBlocked( handle) )
	{
		status = BLO;
	}
	for ( ; it.current(); ++it )
	{
		if( it.current()->text(1) == handle )
		{
			item = it.current();
			switch(status)
			{
				case BLO:
				{
					item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Blocked") + " )" );
					item->setPixmap(0, blockedPixmap );
					break;
				}
				case NLN:
				{
					item->setText(0, theApp->imService->getPublicName( handle) );
					item->setPixmap(0, onlinePixmap );
					break;
				}
				case FLN:
				{
					item->setText(0, theApp->imService->getPublicName( handle) );
					item->setPixmap(0, offlinePixmap );
					break;
				}
				case BSY:
				{
					item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Busy") + " )" );
					item->setPixmap(0, awayPixmap );
					break;
				}
				case IDL:
				{
					item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Away") + " )" );
					item->setPixmap(0, awayPixmap );
					break;
				}
				case AWY:
				{
					item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Away") + " )");
					item->setPixmap(0, awayPixmap );
					break;
				}
				case PHN:
				{
					item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("On the phone") + " )");
					item->setPixmap(0, awayPixmap );
					break;
				}
				case BRB:
				{
					item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Be right back") + " )");
					item->setPixmap(0, awayPixmap );
					break;
				}
				case LUN:
				{
					item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Out to lunch") + " )");
					item->setPixmap(0, awayPixmap );
					break;
				}
			}
		}
	}
}

void OnlineView::slotContactRemoved( QString handle, QString groupName )
{
	theApp->stopWorkTimer();
	QListViewItemIterator it( ListView );
	for ( ; it.current(); ++it )
	{
		if( it.current()->parent() != 0 )
		{
		if( it.current()->parent()->text(0) == groupName )
		{
			if( it.current()->text(1) ==  handle )
			{
				delete it.current();
				return;
			}
		}
		}
	}
}

void OnlineView::slotContactAdded(QString handle, QString publicName, QString groupName)
{
	theApp->stopWorkTimer();
	QListViewItemIterator it( ListView );
	QListViewItem* item;
	uint status;
	for ( ; it.current(); ++it )
	{
		if( it.current()->text(0) == groupName )
		{
			if( it.current()->parent() == 0 ) // groupNames have no parent
			{
				item = new QListViewItem(it.current(), publicName, handle,"1");
				item->setPixmap(0,offlinePixmap);
				status = theApp->imService->getStatus( handle );
				if( theApp->imService->isBlocked( handle) )
				{
					status = BLO;
				}
				switch(status)
				{
					case BLO:
					{
						item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Blocked") + " )" );
						item->setPixmap(0, blockedPixmap );
						break;
					}
					case NLN:
					{
						item->setText(0, theApp->imService->getPublicName( handle) );
						item->setPixmap(0, onlinePixmap );
						break;
					}
					case FLN:
					{
						item->setText(0, theApp->imService->getPublicName( handle) );
						item->setPixmap(0, offlinePixmap );
						break;
					}
					case BSY:
					{
						item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Busy") + " )" );
						item->setPixmap(0, awayPixmap );
						break;
					}
					case IDL:
					{
						item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Away") + " )" );
						item->setPixmap(0, awayPixmap );
						break;
					}
					case AWY:
					{
						item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Away") + " )");
						item->setPixmap(0, awayPixmap );
						break;
					}
					case PHN:
					{
						item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("On the phone") + " )");
						item->setPixmap(0, awayPixmap );
						break;
					}
					case BRB:
					{
						item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Be right back") + " )");
						item->setPixmap(0, awayPixmap );
						break;
					}
					case LUN:
					{
						item->setText(0, theApp->imService->getPublicName( handle) + " ( " + i18n("Out to lunch") + " )");
						item->setPixmap(0, awayPixmap );
						break;
					}
				}
			}
		}
		
	}
}

void OnlineView::slotHideEmail(bool hide)
{
	if (hide)
	{
		mailLabelPixmap->hide();
		mailLabel->hide();
	}
	else
	{
		mailLabelPixmap->show();
		mailLabel->show();
	}
}

void OnlineView::loadIcons()
{
	KIconLoader load;
	Pixmap1		= load.loadIcon("e-mail.png",KIcon::User);
	Pixmap2		= load.loadIcon("filetypes.png",KIcon::User);
	offlinePixmap 	= load.loadIcon("offline.png",KIcon::User);
	onlinePixmap 	= load.loadIcon("online.png",KIcon::User);
	invisiblePixmap	= load.loadIcon("invisible.png",KIcon::User);
	awayPixmap	= load.loadIcon("away.png",KIcon::User);
	blockedPixmap	= load.loadIcon("blocked.png",KIcon::User);
	
	setIcon(load.loadIcon("kmsn.png",KIcon::Small));
	// root pixmaps
	collapsedPixmap	= load.loadIcon("contents2.png",KIcon::Small);
	expandedPixmap	= load.loadIcon("contents.png",KIcon::Small);
	execPixmap	= load.loadIcon("exec.png",KIcon::Small);
}

void OnlineView::slotRightClick(QListViewItem*,const QPoint& point,int)
{
	theApp->slotShowContextMenu(point);
}

//** change the pixmap for root items */
void OnlineView::slotExpanded(QListViewItem *item)
{
	if(item->parent()  == 0){
		item->setPixmap(0,expandedPixmap);
	}
}

void OnlineView::slotCollapsed(QListViewItem *item)
{
	if(item->parent() == 0)
	{
		item->setPixmap(0,collapsedPixmap);
	}
}

void OnlineView::processMailURL(const QString& url)
{
	KRun *run = new KRun("http://www.hotmail.com");

}

void OnlineView::processOnlineURL(const QString&)
{
		QPoint point(30,45);
		point = mapToGlobal(point);
		theApp->fileStatus->popupMenu()->popup(point,0); // ?????

}

void OnlineView::setOnlineLabelText(const QString& text)
{
	QString lable = text;
	lable = lable.replace(QRegExp("<"),"&lt;");
	lable = lable.replace(QRegExp(">"),"&gt;");

	onlineLabel->setText(lable);
}

void OnlineView::setMailLabelText(const QString& text)
{
	mailLabel->setText(text);
}

void OnlineView::slotDbClicked(QListViewItem* item)
{
	if(item != 0)
	{
		if(item->parent() != 0)
		{
			if(theApp->imService->isAvailable(item->text(1)) )
			{
				emit chatToUser(item->text(1));
			}
		}
		else
		{
			return;
		}
	}
}

void OnlineView::slotSelectionChanged(QListViewItem* )
{
	emit selectionChanged();
}


#include "onlineview.moc"

