/***************************************************************************
                       kmfruleeditorinterface.h  -  description
                          -------------------
 begin                : Tue Mar 5 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFRULEEDITORINTERFACE_H
#define KMFRULEEDITORINTERFACE_H

#include <qwidget.h>
#include <kmyfirewallruleeditorinterface.h>
#include "../core/iptrule.h"
#include <qptrlist.h>
#include <qstring.h> 
/**Dialog for setting up interface
dependent rule options.
  *@author Christian Hubinger
  */

class KMFRuleEditorInterface : public KMyFirewallRuleEditorInterface {
	Q_OBJECT
public:
	KMFRuleEditorInterface( QWidget *parent = 0, const char *name = 0, WFlags fl = 0 );
	~KMFRuleEditorInterface();
	IPTRule* curr_rule;
	QPtrList<QString>* options;

	void loadRule( IPTRule* );
public slots:    // Public slots
	void slotCheckConfig();
	void slotOk();
	void slotReadConfig();
	void slotHelp();
	void reject();

signals:
	void sigAddRuleOpt( QString *, QPtrList<QString> * );
	void sigDelRuleOpt( QString * );
	void sigDocumentChanged();
	void sigHideMe();
};

#endif
