/***************************************************************************
begin                : Mon Feb 4 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@gmail.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IPTRULEOPTION_H
#define IPTRULEOPTION_H

#include "netfilterobject.h"

// QT
#include <qstring.h>
#include <qstringlist.h>
#include <qdict.h>

#include <qdom.h>

#include <kdemacros.h>

#define MAXOPTNUM 10

class KMFIPTDoc;
class IPTRule;

/**
  * class IPTRuleOption
  *
  */
class KDE_EXPORT IPTRuleOption : public NetfilterObject {
	//########## BEGIN STATIC ##############

public:
	/** Contains the option commands for each option type. */
	static QDict<QStringList>* getOptionStringDict();
	
	/** Returns a Stringlist containing the user visible strings for the opition */
	static QDict<QStringList>* getGUIStringDict();
	
	/** Return a list of all currently available option types */
	static QPtrList<QString>* getAvailableOptionTypes();
	
	static void readRuleOptionDefinition( const QDomDocument& );
private:
	/** Reads a XML OptionDefinitionNode */
	static void readRuleOptionDefinitionNode( const QDomNode& curr, QStringList* vals, QStringList* gui ) ;

private:  // DATA
	static QDict<QStringList>* m_dict_option_strings;
	static QDict<QStringList>* m_dict_gui_strings;
	static QDict<QString>* m_dict_option_names;
	
	static QPtrList<QString>* m_known_types;
	static bool m_created_dict;
	//########## END STATIC ################

	/** Public methods: */
public:
	IPTRuleOption( IPTRule* = 0 );
	~IPTRuleOption();

	/** restore the opotion config from an xml sniplet */
	void loadXML( const QDomDocument& );

	/** Makes the option empty. */
	void reset();

	/** Returns true if no option values are set */
	bool isEmpty();

	/** Return DomDocument representing this rule() */
	const QDomDocument& getDOMTree( );

	/** Returns a QString containing the option. */
	const QString& toString( );

	/** Set Option Type */
	void setOptionType( const QString& );
	
	/** Return the type of the option. */
	const QString& getOptionType() const {
		return m_option_type;
	};
	
	/** Return the type of the option. */
	const QString& guiName() const ;

	/** Returns true if this is a target option otherwise false*/
	bool isTargetOption() const {
		return m_target_option;
	};

	/** Returns a pointer to the rule to which this options belongs */
	IPTRule* rule() const {
		return m_rule;
	};

	/** Make this option a target option.
		Target options are appended at the very
		end of the rule */
	void setTargetOption( bool );

	/** Load the provided option values in the QStringList. */
	void loadValues( QStringList );

	/** Returns a QStringList containing the option values. */
	const QStringList& getValues();

private:
	IPTRule *m_rule;
	QString m_option_type;
	bool m_target_option;
	QString m_values[ MAXOPTNUM ];
};


#endif // IPTRULEOPTION_H
