//
// C++ Implementation: kmfplugin
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfplugin.h"

// QT includes
#include <qwidget.h>

// KDE includes
#include <kapplication.h>
#include <kdebug.h>

// Project includes
#include "kmyfirewallinterface.h"

#include "../core/kmfgenericdoc.h"
#include "../core/kmfiptdoc.h"
#include "../core/kmfdoc.h"
#include "../core/kmferror.h"


KMFPlugin::KMFPlugin( QObject* parent , const char* name ) : KParts::Plugin( parent , name ) {
	KMyFirewallInterface * m_app = 0;
	m_err = new KMFError();
	m_app = dynamic_cast<KMyFirewallInterface*> ( parent );
	if ( m_app ) {
		kdDebug() << "Found main API" << endl;
	} else {
		kdDebug() << "ERROR: Couldn't find main API" << endl;
	}


}

KMFPlugin::~KMFPlugin() {
	kdDebug() << "Calling Destructor: KMFPlugin::~KMFPlugin()" << endl;
}

KMFDoc* KMFPlugin::doc() {
	KMyFirewallInterface * m_app = 0;
	m_app = dynamic_cast<KMyFirewallInterface*> ( parent() );
	if ( m_app ) {
		kdDebug() << "Found main API" << endl;
		kdDebug() << "Returning valid KMFDoc pointer" << endl;
		return m_app->doc();
	}
	return 0;
}

KMFGenericDoc* KMFPlugin::genericDoc() {
	KMyFirewallInterface * m_app = 0;
	m_app = dynamic_cast<KMyFirewallInterface*> ( parent() );
	if ( m_app ) {
		kdDebug() << "Found main API" << endl;
		KMFDoc *genDoc = m_app->doc();
		if ( KMFGenericDoc* doc = dynamic_cast<KMFGenericDoc*> ( genDoc ) ) {
			kdDebug() << "Returning valid KMFGenericDoc pointer" << endl;
			return doc;
		} else
			kdDebug() << "WARINING: Not workin on KMFGenericDoc" << endl;
	}
	return 0;
}

KMFIPTDoc* KMFPlugin::iptablesDoc() {
	KMyFirewallInterface * m_app = 0;
	m_app = dynamic_cast<KMyFirewallInterface*> ( parent() );
	if ( m_app ) {
		kdDebug() << "Found main API" << endl;
		KMFDoc *genDoc = m_app->doc();
		if ( KMFIPTDoc* doc = dynamic_cast<KMFIPTDoc*> ( genDoc ) ) {
			kdDebug() << "Returning KMFIPTDoc doc pointer" << endl;
			return doc;
		} else
			kdDebug() << "WARINING: Not workin on KMFIPTDoc" << endl;
	}
	return 0;
}

void KMFPlugin::setOutputWidget( QWidget* wid ) {
	KMyFirewallInterface * m_app = 0;
	m_app = dynamic_cast<KMyFirewallInterface*> ( parent() );
	if ( m_app ) {
		kdDebug() << "Found main API" << endl;
		m_app->setOutputWidget( wid );
	} else {
		kdDebug() << "ERROR: Couldn't find main API" << endl;
	}
}

void KMFPlugin::showEditor() {
KMyFirewallInterface * m_app = 0;
	m_app = dynamic_cast<KMyFirewallInterface*> ( parent() );
	if ( m_app ) {
		kdDebug() << "Found main API" << endl;
		m_app->showEditor();
	} else {
		kdWarning() << "ERROR: KMFPlugin::showEditor()- Couldn't find main API" << endl;
	}
}

void KMFPlugin::showOutput() {
	KMyFirewallInterface * m_app = 0;
	m_app = dynamic_cast<KMyFirewallInterface*> ( parent() );
	if ( m_app ) {
		kdDebug() << "Found main API" << endl;
		m_app->showOutput();
	} else {
		kdWarning() << "ERROR: KMFPlugin::showOutput() - Couldn't find main API" << endl;
	}
}

void KMFPlugin::checkStatus() {
	KMyFirewallInterface * m_app = 0;
	m_app = dynamic_cast<KMyFirewallInterface*> ( parent() );
	if ( m_app ) {
		kdDebug() << "Found main API" << endl;
		m_app->checkStatus();
	} else {
		kdWarning() << "ERROR: KMFPlugin::checkStatus() - Couldn't find main API" << endl;
	}
}
