//
// C++ Implementation: kmfchecklistitem
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@gmail.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfchecklistitem.h"

// QT includes

// KDE includes
#include <kdebug.h>

// Project includes
#include "../core/netfilterobject.h"
#include "../core/kmfprotocol.h"

KMFCheckListItem::KMFCheckListItem( QListView *parent, QListViewItem *after, const QString& text, Type tt, NetfilterObject* obj ) : QCheckListItem( parent, after, text,  tt ) {
	loadNetfilterObject( obj );
}
KMFCheckListItem::KMFCheckListItem( QListViewItem *parent, const QString& text , Type tt, NetfilterObject* obj ) : QCheckListItem( parent, text,  tt ) {
	loadNetfilterObject( obj );
}
KMFCheckListItem::KMFCheckListItem( QListViewItem *parent, QListViewItem *after, const QString& text, Type tt, NetfilterObject* obj ) : QCheckListItem( parent, after, text,  tt ) {
	loadNetfilterObject( obj );
}

KMFCheckListItem::~KMFCheckListItem() {}


void KMFCheckListItem::loadNetfilterObject( NetfilterObject* obj ) {
	if ( KMFProtocol *prot = dynamic_cast<KMFProtocol*> ( obj ) ) {
		m_protocol = prot;
	} else {
		kdDebug() << "ERROR: Given NetfilterObject has wrong type" << endl;
	}
}

