/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@gmail.com>, (C) 2001-2004
*/

#include "kmfruleeditmac.h"

#include <qcheckbox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kapplication.h>

// project includes
#include "../../core/iptrule.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfcheckinput.h"
#include "../../core/kmferror.h"
#include "../../core/kmferrorhandler.h"

/*
 *  Constructs a KMFRuleEditMac which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KMFRuleEditMac::KMFRuleEditMac( QWidget* parent, const char* name, WFlags fl )
		: KMyFirewallRuleEditorMac( parent, name, fl ) {
	m_err_handler = new KMFErrorHandler( "KMFRuleEditMac" );
	m_check_input = new KMFCheckInput();
	m_err = new KMFError();


}

/*
 *  Destroys the object and frees any allocated resources
 */
KMFRuleEditMac::~KMFRuleEditMac() {
	// no need to delete child widgets, Qt does it all for us
}

/*
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool KMFRuleEditMac::event( QEvent* ev ) {
	bool ret = QWidget::event( ev );
	if ( ev->type() == QEvent::ApplicationFontChange ) {}
	return ret;
}

void KMFRuleEditMac::loadRule( IPTRule * rule ) {
	kdDebug() << "void KMFRuleEditMac::loadRule( IPTRule * rule )" << endl,
	c_src_mac->setChecked( false );
	c_inv_src_mac->setChecked( false );
	t_src_mac1 ->clear();
	t_src_mac2 ->clear();
	t_src_mac3 ->clear();
	t_src_mac4 ->clear();
	t_src_mac5 ->clear();
	t_src_mac6 ->clear();
	m_rule = rule;
	QString line = "";

	IPTRuleOption* opt = 0;
	opt = m_rule->getOptionForName("mac_opt");
	if ( opt ) {
		QStringList args = opt->getValues();
		QString src, dest;
		line = *args.at(1);
		if ( line.isEmpty() || line == "UNDEFINED"  )
			return;
		if ( line.startsWith( "! " ) ) {
			kdDebug() << "Found Invert Flag" << endl;
			line = line.right( line.length() - 2 );
			c_inv_src_mac->setChecked( true );
		}
		kdDebug() << "Found Mac Address: " << line << endl;
		int num = 1;
		QString part = "";
		c_src_mac->setChecked( true );
		while ( !line.isEmpty() ) {
			int pos = -1;
			pos = line.find( ":" );
			if ( pos < 0 ) {
				part = line;
				kdDebug() << "Found last digit: " << part << endl;
				line = "";
			} else {
				kdDebug() << "found delim: " << pos << endl;
				part = line.left( pos );
				kdDebug() << "Token Nr." << num << ": " << part << endl;
				line = line.right( line.length() - ( pos + 1 ) );
				kdDebug() << "Rest: " << line << endl;
			}
			switch ( num ) {
				case 1:
					t_src_mac1 -> setText( part );
					break;
				case 2:
					t_src_mac2 -> setText( part );
					break;
				case 3:
					t_src_mac3 -> setText( part );
					break;
				case 4:
					t_src_mac4 -> setText( part );
					break;
				case 5:
					t_src_mac5 -> setText( part );
					break;
				case 6:
					t_src_mac6 -> setText( part );
					break;
			}
			num++;
		}
	}
}


void KMFRuleEditMac::accept() {
	kdDebug() << "KMFRuleEditMac::accept()" << endl;
	m_rule->chain()->table()->kmfDoc()->startTransaction();
	m_rule->saveState();
	QString tok1 = t_src_mac1->text().upper();
	QString tok2 = t_src_mac2->text().upper();
	QString tok3 = t_src_mac3->text().upper();
	QString tok4 = t_src_mac4->text().upper();
	QString tok5 = t_src_mac5->text().upper();
	QString tok6 = t_src_mac6->text().upper();

	if ( c_src_mac->isChecked() && ( tok1.isEmpty() || tok2.isEmpty() || tok3.isEmpty() || tok4.isEmpty() || tok5.isEmpty() || tok6.isEmpty() ) ) {
		const QString & msg = i18n( "One ore more of the fields are empty. Please fill out all fields to define a valid MAC address." );
		KMessageBox::error( this, msg );
		m_rule->chain()->table()->kmfDoc()->endTransaction();
		return ;
	}

	QString mac = "";

	if ( c_src_mac->isChecked() ) {
		mac = tok1 + ":" + tok2 + ":" + tok3 + ":" + tok4 + ":" + tok5 + ":" + tok6;
		m_check_input->checkInput( mac, "MAC", m_err );
		if ( ! m_err_handler->showError( m_err ) ) {
			m_rule->chain()->table()->kmfDoc()->endTransaction();
			return ;
		}
	}

	QPtrList<QString>* values = new QPtrList<QString>;
	QString* op = new QString( "mac_opt" );
	if ( c_src_mac->isChecked() && !mac.isEmpty() ) {
		kdDebug() << "Add new mac option" << endl;
		QString* src_mac = new QString( mac );
		if ( c_inv_src_mac->isChecked() ) {
			src_mac->prepend( "! " );
		}
		values->append( new QString( "bool:on" ) );
		values->append( src_mac );
	}
	emit sigAddRuleOpt( op, values );
	m_rule->chain()->table()->kmfDoc()->endTransaction();
	emit sigHideMe();
}

void KMFRuleEditMac::slotHelp() {
	kdDebug() << "void KMFRuleEditMac::slotHelp()" << endl;
	kapp->invokeHelp( "src_mac" );
}
void KMFRuleEditMac::reject() {
	kdDebug() << "void KMFRuleEditMac::reject()" << endl;
	emit sigHideMe();
}
#include "kmfruleeditmac.moc"
