//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICINTERFACEHOST_H
#define KMFGENERICINTERFACEHOST_H

#include "kmyfirewallgenericinterfacehostwidget.h"

/**
@author Christian Hubinger
*/

// QT includes

#include <qstring.h>
#include <qguardedptr.h>
#include <qpixmap.h>
#include <quuid.h>

class QListViewItem;

// KDE includes

class KPopupMenu;

namespace KMF {
// Project Includes
class KMFNetwork;
class KMFGenericDoc;
class KMFNetZone;
class KMFNetHost;
class KMFListViewItem;
class NetfilterObject;

class KMFGenericInterfaceHost : public KMyFirewallGenericInterfaceHostWidget {
	Q_OBJECT
public:
	KMFGenericInterfaceHost( QWidget *parent = 0, const char *name = 0, WFlags f = 0 );

	~KMFGenericInterfaceHost();

public:
	void loadDoc( KMFNetwork* );

public slots:
	void slotUpdateView();
	void slotUpdateView( NetfilterObject* );

private slots:
	void slotZoneRBM( QListViewItem*, const QPoint&, int );
	void slotNewHost();
    void slotDelHost();
    void slotNewItemSelected( QListViewItem* );
    void slotRenameHost();
	void slotHostRenamed( QListViewItem*, int , const QString & );
	void slotAddressChanged( const QString& );
	void slotHostDescChanged();
	void slotLoggingChanged( bool );
	// void slotDisable();
	
private:
	void loadIcons();
	KMFListViewItem* findKMFItem( const QString& text, const QUuid& obj_id );
	KMFListViewItem* findKMFItem( const QUuid&  obj_id );

	QGuardedPtr<KMFNetZone> m_zone;
	QGuardedPtr<KMFNetHost> m_host;
	QGuardedPtr<KMFNetwork> m_doc;
	KPopupMenu* m_contextMenu;

	KMFListViewItem *itemTrustedHosts;
	KMFListViewItem *itemMaliciousHosts;
	KMFListViewItem *itemBadServers;
	KMFListViewItem *itemBadClients;



	QPixmap icon_up, icon_down, icon_del, icon_edit, icon_rule, icon_filter, icon_rename,
	icon_chain, icon_log, icon_accept, icon_drop, icon_cmd, icon_reject, icon_return,
		icon_target, icon_queue, icon_new, icon_copy, icon_move;

};
}
#endif
