//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "kmfnethostpropertieswidget.h"

// QT includes
#include <qlistview.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qwidgetstack.h>
#include <qtextedit.h>
#include <qframe.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <klistview.h>
#include <kcombobox.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <knuminput.h>

// Project Includes
#include "../core/kmftarget.h"
#include "../core/ipaddress.h"
#include "../core/kmfnethost.h"
#include "../core/kmfnetzone.h"
#include "../core/kmfundoengine.h"

#include "kmfipv4addresswidget.h"
namespace KMF {
KMFNetHostPropertiesWidget::KMFNetHostPropertiesWidget ( QWidget* parent, const char* name, WFlags fl )
		: KMyFirewallNetHostProperties ( parent,name,fl ) {
		
	m_address_widget = new KMFIPv4AddressWidget( m_frameAddress, "m_address_widget" );
	
	connect( m_address_widget, SIGNAL( sigAddressChanged( int, int, int, int ) ),
		this,SLOT( slotAddressChanged( int, int, int, int ) ) );
	
	connect( m_cb_host_limit, SIGNAL( toggled( bool ) ), 
		this, SLOT( slotHostLimitToggled( bool ) ) );	
	
	connect( m_sb_host_rate, SIGNAL( valueChanged( int ) ),
		this, SLOT( slotHostLimitValueChanged( int ) ) );
	
	connect( m_cb_limit_host_interval, SIGNAL( activated( int ) ),
		this, SLOT( slotHostLimitScaleChanged( int ) ) );
	
	connect( m_cb_host_log, SIGNAL( toggled( bool ) ),
		this, SLOT( slotHostLogToggled( bool ) ) );

	connect( m_host_desc, SIGNAL( textChanged() ),
		this, SLOT( slotDescriptionChanged() ) );
	
    QGridLayout *grid = new QGridLayout( m_frameAddress, 1, 1 );
	grid->addWidget( m_address_widget, 0, 0 );
	m_frameAddress->adjustSize();
	adjustSize();
}

KMFNetHostPropertiesWidget::~KMFNetHostPropertiesWidget() {}

void KMFNetHostPropertiesWidget::blockAllSignals( bool onoff ) {
	m_cb_limit_host_interval->blockSignals( onoff );
	m_cb_host_limit->blockSignals( onoff );
	m_sb_host_rate->blockSignals( onoff );
	m_host_desc->blockSignals( onoff );
}

void KMFNetHostPropertiesWidget::slotHostDeleted() {
	setEnabled( false );
	m_host = 0;
}	

void KMFNetHostPropertiesWidget::loadHost( KMFNetHost* host ) {
	kdDebug() << "KMFNetHostPropertiesWidget::loadTarget( KMFNetHost* host " << endl;
	if ( ! host ) {
		return;
	}
	
	if ( m_host ) {
		disconnect( m_host, SIGNAL( destroyed() ),
			this,SLOT( slotHostDeleted() ) );
	}
	
	m_host = host;
	connect( m_host, SIGNAL( destroyed() ),
			this,SLOT( slotHostDeleted() ) );
	blockAllSignals( true );
	setEnabled( true );
	m_address_widget->loadIPAddress( 
		m_host->address()->getDigit( 0 ),
		m_host->address()->getDigit( 1 ),
		m_host->address()->getDigit( 2 ),
		m_host->address()->getDigit( 3 )
	);
	if (  m_host->limit() ) {
		m_cb_host_limit->setChecked( true );
		m_sb_host_rate->setEnabled( true );
		m_cb_limit_host_interval->setEnabled( true );
		m_sb_host_rate->setValue( m_host->limitRate() );
		kdDebug() << "Found host log scale: " << m_host->limitScale() << endl;
		
		m_cb_limit_host_interval->blockSignals( true );
		if (  m_host->limitScale() == "second" ) {
			m_cb_limit_host_interval->setCurrentItem( 0 );
		} else if ( m_host->limitScale() == "minute" ) {
			m_cb_limit_host_interval->setCurrentItem( 1 );
		} else if ( m_host->limitScale() == "hour" ) {
			m_cb_limit_host_interval->setCurrentItem( 2 );
		} else {
			kdDebug() << "Found illefal value: " << m_host->limitScale() << endl;
		}
		m_cb_limit_host_interval->blockSignals( false );
		
	} else {
		m_cb_host_limit->setChecked( false );
		m_sb_host_rate->setEnabled( false );
		m_cb_limit_host_interval->setEnabled( false );
	}
	
	KMFNetZone* parentZone = m_host->zone()->rootZone();
	if ( parentZone->name() == "incoming_world" ) {
		m_cb_host_log->setChecked( m_host->logIncoming() );
	} else if (  parentZone->name() == "outgoing_world" ) {
		m_cb_host_log->setChecked( m_host->logOutgoing() );
	}
	
	if ( m_host_desc->text().simplifyWhiteSpace() != m_host->description() ) {
		m_host_desc->blockSignals( true );
		m_host_desc->setText(  m_host->description() );
		m_host_desc->blockSignals( false );
	}
	m_host_desc->setReadOnly( false );
	blockAllSignals( false );
}

void KMFNetHostPropertiesWidget::slotAddressChanged( int d0, int d1, int d2, int d3 ) {
	kdDebug() << "KMFNetHostPropertiesWidget::slotAddressChanged( " 
		<< d0 << "." 
		<< d1 << "." 
		<< d2 << "."
		<< d3 << ")" << endl;
	KMFUndoEngine::instance()->startTransaction( 
			m_host,
			i18n("Change address of Host: %1.").arg( m_host->guiName() )  
	);
	m_host->address()->setAddress( d0, d1, d2, d3 );
	m_host->zone()->rootZone()->placeHostInZone( m_host );
	m_host->zone()->rootZone()->refreshNetworkTree();
	KMFUndoEngine::instance()->endTransaction();
	
	emit sigHostAddressChanged( m_host->address()->toString() );
	// emit sigHostChanged( m_host );
}


void KMFNetHostPropertiesWidget::slotHostLogToggled( bool ) {
	kdDebug() << "void KMFNetHostPropertiesWidget::slotHostLogToggled( bool )" << endl;
	if ( ! m_host )
		return;
	 kdDebug() << "Changing host: " << m_host->guiName() << endl;		
	
	KMFNetZone* parentZone = m_host->zone()->rootZone();
	if ( parentZone->name() == "incoming_world" ) {
		if ( m_host->logIncoming() == m_cb_host_log->isChecked() ) {
			return;
		}
		KMFUndoEngine::instance()->startTransaction(
			m_host,
			i18n( "%1 logging of incoming packets for host %2." ).arg( m_cb_host_log->isChecked() ? i18n( "Enable" ) : i18n( "Disable" ) ).arg( m_host->guiName() )
		);
		m_host->setLogIncoming( m_cb_host_log->isChecked() );
		KMFUndoEngine::instance()->endTransaction();
	} else if (  parentZone->name() == "outgoing_world" ) {
		if ( m_host->logOutgoing() == m_cb_host_log->isChecked() ) {
			return;
		}
		KMFUndoEngine::instance()->startTransaction(
			m_host,
			i18n( "%1 logging of outgoing packets for host %2." ).arg( m_cb_host_log->isChecked() ? i18n( "Enable" ) : i18n( "Disable" ) ).arg( m_host->guiName() )
		);
		m_host->setLogOutgoing( m_cb_host_log->isChecked() );
		KMFUndoEngine::instance()->endTransaction();
	}
	emit sigHostChanged( m_host );
}

void KMFNetHostPropertiesWidget::slotHostLimitToggled( bool on ){
	kdDebug() << "void KMFNetHostPropertiesWidget::slotHostLimitToggled( bool " << on << " )" << endl;
	if ( ! m_host )
		return;
	kdDebug() << "Changing host: " << m_host->guiName() << endl;
	if ( on ) {
		KMFUndoEngine::instance()->startTransaction(
			m_host,
			i18n( "Enable package limit for host %1." ).arg( m_host->guiName() )
		);
		m_host->setLimit( m_sb_host_rate->value(),  m_cb_limit_host_interval->currentText() );
		KMFUndoEngine::instance()->endTransaction();
	} else {
		KMFUndoEngine::instance()->startTransaction(
			m_host,
			i18n( "Disable package limit for host %1." ).arg( m_host->guiName() )
		);
		m_host->setLimit( -1, m_cb_limit_host_interval->currentText() );
		KMFUndoEngine::instance()->endTransaction();
	}
	emit sigHostChanged( m_host );
}

void KMFNetHostPropertiesWidget::slotHostLimitValueChanged( int ) {
	kdDebug() << "void KMFNetHostPropertiesWidget::slotHostLimitValueChanged( int )" << endl;
	if ( ! m_host )
		return;
	kdDebug() << "Changing host: " << m_host->guiName() << endl;	
	if ( m_cb_host_limit->isChecked() ) {
		KMFUndoEngine::instance()->startTransaction(
			m_host,
			i18n( "Change package limit for host %1 to %2/%3." ).arg( m_host->guiName() ).arg(  m_sb_host_rate->value() ).arg( m_cb_limit_host_interval->currentText() )
		);
		m_host->setLimit( m_sb_host_rate->value(),  m_cb_limit_host_interval->currentText() );
		KMFUndoEngine::instance()->endTransaction();
	} else {
		KMFUndoEngine::instance()->startTransaction(
			m_host,
			i18n( "Disable package limit for host %1." ).arg( m_host->guiName() )
		);
		m_host->setLimit( -1, m_cb_limit_host_interval->currentText() );
		KMFUndoEngine::instance()->endTransaction();
	}
	emit sigHostChanged( m_host );
}

void KMFNetHostPropertiesWidget::slotHostLimitScaleChanged( int ) {
	kdDebug() << "void KMFGenericInterfaceProtocol::slotHostLimitValueChanged( int )" << endl;
	if ( ! m_host )
		return;
	kdDebug() << "Changing host: " << m_host->guiName() << endl;	
	if ( m_cb_host_limit->isChecked() ) {
		KMFUndoEngine::instance()->startTransaction(
			m_host,
			i18n( "Change package limit for host %1 to %2/%3." ).arg( m_host->guiName() ).arg(  m_sb_host_rate->value() ).arg( m_cb_limit_host_interval->currentText() )
		);
		m_host->setLimit( m_sb_host_rate->value(),  m_cb_limit_host_interval->currentText() );
		KMFUndoEngine::instance()->endTransaction();
	} else {
		KMFUndoEngine::instance()->startTransaction(
			m_host,
			i18n( "Disable package limit for host %1." ).arg( m_host->guiName() )
		);
		m_host->setLimit( -1, "" );
		KMFUndoEngine::instance()->endTransaction();
	}
	emit sigHostChanged( m_host );
}

void KMFNetHostPropertiesWidget::slotDescriptionChanged() {
	kdDebug() << "void KMFNetHostPropertiesWidget::slotDescriptionChanged( const QString& )" << endl;
	if ( ! m_host ) {
		return;
	}
	QString newTxt = m_host_desc->text().simplifyWhiteSpace();
	if ( newTxt != m_host->description() ) {
		KMFUndoEngine::instance()->startTransaction(
			m_host,
			i18n( "Change documentation of host: %1" ).arg( m_host->guiName() )
		);
		m_host->setDescription( newTxt );
		KMFUndoEngine::instance()->endTransaction();
	}
	emit sigHostChanged( m_host );
}

}

#include "kmfnethostpropertieswidget.moc"

