//
// C++ Interface:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef KMFNETHOSTPROPERTIESWIDGET_H
#define KMFNETHOSTPROPERTIESWIDGET_H

#include "kmyfirewallnethostproperties.h"

// QT include
#include <qguardedptr.h>

namespace KMF {
class KMFNetHost;
class KMFIPv4AddressWidget;

class KMFNetHostPropertiesWidget : public KMyFirewallNetHostProperties {
		Q_OBJECT

	public:
		KMFNetHostPropertiesWidget ( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		~KMFNetHostPropertiesWidget();
		/*$PUBLIC_FUNCTIONS$*/
		
		void loadHost( KMFNetHost* );
	public slots:
		/*$PUBLIC_SLOTS$*/
		
	protected:
		/*$PROTECTED_FUNCTIONS$*/

	protected slots:
		/*$PROTECTED_SLOTS$*/
		void slotAddressChanged( int, int, int, int );
		void slotHostLimitToggled( bool );
		void slotHostLogToggled( bool );
		void slotHostLimitValueChanged( int );
		void slotHostLimitScaleChanged( int );
		void slotDescriptionChanged();
		void slotHostDeleted();	
	
	private:
		void blockAllSignals( bool );
	
	private: 
		QGuardedPtr<KMFNetHost> m_host;
		KMFIPv4AddressWidget *m_address_widget;
		
	signals:	
		void sigHostAddressChanged( const QString& );
		void sigHostChanged( KMFNetHost* );
};
}
#endif

