/***************************************************************************
                          songinfo.cpp  -  description
                             -------------------
    begin                : Wed Dec 8 1999
    copyright            : (C) 1999-2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "songinfo.h"

#include "md5.h"

#include <iostream.h>

#include <qdir.h>
#include <qfile.h>


class MP3Header
{
public:
  unsigned short sync;
  int version;
  bool protect;
  int layer;

  int bitrate;
  int freq;

  bool padding;
  int channels;
  int ext;
  bool copyright;
  bool original;
  int emphasis;

  unsigned long seconds;
};

bool readMP3Header(QFile *afile,MP3Header *mp3hdr);
QString calcMD5(QFile *afile);



SongInfo::SongInfo(const char *_filename,const char *_id,long _size,int _bitrate,int _freq,
       long _snum,const char *_user,unsigned long _ip,int _port,int _speed)
{
  filename=_filename;
  md5=_id;
  size=_size;
  bitrate=_bitrate;
  freq=_freq;
  songnum=_snum;
  user=_user;
  ip=_ip;
  port=_port;
  speed=_speed;

  shared=true;

  dload=NULL;


  read=0;
  rate=0;
  status=0;
  bps=0;

  ignore=false;

  internal_id = "";
  fullpathname ="";
}
SongInfo::~SongInfo()
{
}

SongInfo::SongInfo(const SongInfo &s)
{
  filename=s.filename;
  md5=s.md5;
  size=s.size;
  bitrate=s.bitrate;
  freq=s.freq;
  songnum=s.songnum;
  user=s.user;
  ip=s.ip;
  port=s.port;

  speed=s.speed;

  shared=s.shared;

  read=s.read;
  rate=s.rate;
  status=s.status;
  bps=s.bps;

  ignore=s.ignore; // ignore messages about this song

  dload=NULL;

  seconds=s.seconds;

  internal_id = s.internal_id;

  fullpathname = s.fullpathname;
}

bool SongInfo::loadMD5()
{
  QFile afile;

  afile.setName(filename);
  afile.open(IO_ReadOnly);

  if(!afile.isOpen()) return false;

  // calc md5
  md5 = calcMD5(&afile) + "-" + QString().setNum(afile.size());
  return true;
}

// read in a song and make a songinfo structure of its info
// NOTE: the info returned is a static ptr nd shouldn't be deleted
// if getall is true it gets all info it can in the info struct
// otherwise it just gets the size,bitrate,freq
SongInfo *SongInfo::loadSongInfo(const char *fname,bool getall)
{
  static SongInfo asong;

  MP3Header h;

  QFile afile;

  if(!fname) return NULL;

  afile.setName(fname);
  afile.open(IO_ReadOnly);

  asong.filename = fname; // **** NOTE: must be a windoze name here
                          // so convert it to a windows path
  if(!afile.isOpen()) return NULL;

  asong.size=afile.size();

  if(readMP3Header(&afile,&h)) {
    asong.freq = h.freq;
    asong.bitrate = h.bitrate;
    asong.seconds=h.seconds;
  }
  else {
    asong.freq = 0;
    asong.bitrate = 0;
    asong.seconds=0;
  }

  // if we want to get it all and we don't yet have the md5
  if(getall /*&& asong.md5.isEmpty()*/)
  {
// TODO    asong.loadMD5();
  }
  else asong.md5="";

#ifdef DEBUG_2
  cerr<<"sginfo: "<<fname<<" sz: "<<asong.size
    <<" freq: "<<asong.freq<<" br: "<<asong.bitrate<<" time: "
    <<asong.seconds
    <<" mdr"<<asong.md5<<endl
    <<flush;
#endif

  return &asong;
}


const int bitrate_tbl[2][3][16] = {
{
 //MPEG 2 & 2.5
 {0,  8, 16, 24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160,0}, //Layer III
 {0,  8, 16, 24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160,0}, //Layer II
 {0, 32, 48, 56, 64, 80, 96,112,128,144,160,176,192,224,256,0}  //Layer I
},
{
 //MPEG 1
 {0, 32, 40, 48, 56, 64, 80, 96,112,128,160,192,224,256,320,0}, //Layer III
 {0, 32, 48, 56, 64, 80, 96,112,128,160,192,224,256,320,384,0}, //Layer II
 {0, 32, 64, 96,128,160,192,224,256,288,320,352,384,416,448,0}  //Layer I
}
};

static int freq_tbl[4][3] = {
  {32000, 16000,  8000}, //MPEG 2.5
  {    0,     0,     0}, //reserved
  {22050, 24000, 16000}, //MPEG 2
  {44100, 48000, 32000}  //MPEG 1
};

// private func ( not even in the class for determining the header ) */
bool readMP3Header(QFile *afile,MP3Header *mp3hdr)
{
//  0000 0000 0000 0000 0000 0000 0000 0000

  char tmp[14];
  unsigned long bithdr;
  int trycnt=0;

  if(!afile) return false;

  afile->readBlock(&tmp[1],3);

  do {
    tmp[0]=tmp[1];
    tmp[1]=tmp[2];
    tmp[2]=tmp[3];
    afile->readBlock(&tmp[3],1);

    if(trycnt==0 && tmp[0]=='I' && tmp[1]=='D'
       && tmp[2]=='3' && tmp[3]<=0x3) {
       // some mp3 seem to have the tag at the start of the file
       // - starts with ID3\0003

       // look for the possible header

       while(tmp[0]!=-1) {
         if(afile->atEnd()) return false;

         afile->readBlock(&tmp[0],1);
       }

       afile->readBlock(&tmp[1],3);
    }

    bithdr = (unsigned long)(
      ( (tmp[0] & 255) << 24) | ( (tmp[1] & 255) << 16) |
      ( (tmp[2] & 255) <<  8) | ( (tmp[3] & 255)      )
    );

    mp3hdr->sync =  (bithdr >> 21)&0x7ff;
    mp3hdr->version = ((bithdr >> 19)&0x3);
    mp3hdr->layer = ((bithdr >> 17)&0x3);
    mp3hdr->bitrate = ((bithdr >> 12)&0xf);
    mp3hdr->freq = ((bithdr >> 10)&0x3);

    trycnt++;

    if(trycnt>=500) return false;

  } while(mp3hdr->sync!=0x7ff ||  mp3hdr->version==1
      || mp3hdr->layer==0 || mp3hdr->bitrate==0xf
      || mp3hdr->freq==3 );

  mp3hdr->protect = ((bithdr >> 16)&0x1);

  // get index & calc brate from it
  mp3hdr->bitrate =
      bitrate_tbl[mp3hdr->version & 1][mp3hdr->layer - 1][mp3hdr->bitrate];

  mp3hdr->freq =
      freq_tbl[mp3hdr->version][mp3hdr->freq];

  mp3hdr->padding = ((bithdr >> 9)&0x1);
  mp3hdr->channels = ((bithdr >> 6)&0x3);
  mp3hdr->ext = ((bithdr >> 4)&0x3);
  mp3hdr->copyright = ((bithdr >> 3)&0x1);
  mp3hdr->original = ((bithdr >> 2)&0x1);
  mp3hdr->emphasis = (bithdr & 0x3);

  int skip=0;

  // is there a variable bit rate bit
  if(mp3hdr->version==3 ) {  // mpeg version 1
     if(mp3hdr->channels==3) skip = 17; // Single Channel
     else skip = 32;
  }
  else { // mpeg version 2 or 2.5
   if(mp3hdr->channels==3 ) skip = 9; // Single Channel
   else skip = 17;
  }

  // read next twelve bits in
  for(int i=0;i<skip;i++) afile->readBlock(tmp,1);

  afile->readBlock (tmp, 12);

  if(strncmp("Xing",tmp,4)==0) {
#ifdef DEBUG_1
     cerr<<"got a variable bitrate***************************\n"<<flush;
#endif
     bithdr = (unsigned long)(
        (tmp[4] << 24) |
        (tmp[5] << 16) |
        (tmp[6] <<  8) |
        (tmp[7]      )
     );
     if(bithdr &  1) { // there is frame data
      // get the num of frames
       bithdr = (unsigned long)(
        (tmp[8] << 24) |
        (tmp[9] << 16) |
        (tmp[10] <<  8) |
        (tmp[11]      )
       );

       float framesize = (float)afile->size() / (float)bithdr;
       mp3hdr->bitrate =
         (int)(( framesize * (float)mp3hdr->freq)
              /( 1000.0 * ( (mp3hdr->layer==3) ? 12.0 : 144.0)) );
     }
  }

  mp3hdr->seconds = (8 * afile->size() ) / 1000;
  if(mp3hdr->bitrate) mp3hdr->seconds=mp3hdr->seconds/mp3hdr->bitrate;
  else mp3hdr->seconds=0;

  return true;
}

QString calcMD5(QFile *afile)
{
  QString s;
  unsigned int sz;
  int done=299008;
  char buff[1024]="0123456776543210";
  MD5_CTX ctx;

  sz = afile->readBlock(buff,1024);
  if(sz<=0) return QString("");

 
  MD5Init(&ctx);

  while(done>0 && sz>0) {

    MD5Update(&ctx,(unsigned char *)buff,sz);

    // get next block
    done-=sz;
    if(done<1024) sz=done;
    else sz=1024;
    sz = afile->readBlock(buff,1024);
  }
  MD5Final((unsigned char *)buff,&ctx,true);
  buff[32]='\0';

#ifdef DEBUG_3
  cerr<<"%%%%******* ";
  for(int i=0;i<16;i++)
    cerr<<(int)buff[i]<<" ";
  cerr<<endl<<flush;
#endif


  return QString(buff);
}
