#include <klocale.h>
#include "knap_whois.h"

#include "support_funcs.h"

#include <qframe.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/* 
 *  Constructs a KNAP_Whois which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
// TODO need to handle both online and offline datas
KNAP_Whois::KNAP_Whois( QString &data )
    : QWidget( 0,"whois" )
{
//    if ( !name )
//	setName( "whois" );
//    resize( 224, 371 ); 
    setCaption("Knapster2");
    
    QGridLayout* whoisLayout = new QGridLayout( this ); 
    whoisLayout->setSpacing( 6 );
    whoisLayout->setMargin( 11 );

    QFrame * line = new QFrame( this, "Line0" );
    line->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    whoisLayout->addMultiCellWidget( line, 1, 1, 0, 1 );

    infolabel = new QLabel( this, "infolabel" );
/*
    infolabel->setText( i18n( " <b>Username:</b>	wearable_computer<br>\n <b>Class:</b>		Elite<br>\n <b>Logged on for:</b>	16s<br>\n <b>Channels:</b>	<br>\n Status:    Active<br>\n shared:    4<br>\n downloads: 0<br>\n uploads:   0<br>\n Speed:   14.4K<br>\n  client:   knapster0.14<br>\n total uploads:   0<br>\n total downloads: 0<br>\n ip:              210.9.18.100<br>\n conn port:       1218<br>\n port:            6699<br>\n email:           unknown<br>"  ) );
*/
    infolabel->setTextFormat( QLabel::RichText );
    infolabel->setAlignment( int( QLabel::WordBreak | QLabel::AlignTop | QLabel::AlignLeft ) );
    infolabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)3, infolabel->sizePolicy().hasHeightForWidth() ) );

    whoisLayout->addMultiCellWidget( infolabel, 2, 2, 0, 1 );

    usernamelabel = new QLabel( this, "usernamelabel" );
    usernamelabel->setText( i18n( "UName"  ) );
    QFont usernamelabel_font(  usernamelabel->font() );
    usernamelabel_font.setBold( TRUE );
    usernamelabel->setFont( usernamelabel_font ); 
    usernamelabel->setAlignment( int( QLabel::AlignCenter ) );
    usernamelabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, usernamelabel->sizePolicy().hasHeightForWidth() ) );

    whoisLayout->addMultiCellWidget( usernamelabel, 0, 0, 0, 1 );

    closebutton = new QPushButton( this, "closebutton" );
    closebutton->setText( i18n( "&Close"  ) );
    closebutton->setDefault( TRUE );
    closebutton->setFlat( FALSE );

    whoisLayout->addWidget( closebutton, 4, 1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    whoisLayout->addItem( spacer, 4, 0 );

    line = new QFrame( this, "Line1" );
    line->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    whoisLayout->addMultiCellWidget( line, 3, 3, 0, 1 );

    // signals and slots connections
    connect( closebutton, SIGNAL( clicked() ), this, SLOT( close() ) );

    setOnlineData(data);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KNAP_Whois::~KNAP_Whois()
{
    // no need to delete child widgets, Qt does it all for us
}

/*  
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
/*
bool KNAP_Whois::event( QEvent* ev )
{
    bool ret = QWidget::event( ev ); 
    if ( ev->type() == QEvent::ApplicationFontChange ) {
	QFont usernamelabel_font(  usernamelabel->font() );
	usernamelabel_font.setBold( TRUE );
	usernamelabel->setFont( usernamelabel_font ); 
    }
    return ret;
}
*/
void KNAP_Whois::setOnlineData(QString &s)
{
  QString tmp;
  QString work=s;
  
  QString finalstr = "<b>Username:  </b> ";
  tmp=extractString(work);
  usernamelabel->setText(tmp);
  finalstr += tmp; 
  
  finalstr += "<br><b> Class:     </b>";
  finalstr += extractString(work);

  finalstr += "<br><b> Logged on for: </b>";
  tmp=extractString(work);
  // time in seconds that the user has been on
  finalstr += convertSecondsToDurationString(tmp.toLong());

  finalstr += "<br><b> Channels: </b>";
  finalstr += extractString(work);

  finalstr += "<br><b> Status: </b>";
  finalstr += extractString(work);

  finalstr += "<br><b> Shared: </b>";
  finalstr += extractString(work);

  finalstr += "<br><b> Downloads: </b>";
  finalstr += extractString(work);

  finalstr += "<br><b> Uploads: </b>";
  finalstr += extractString(work);

  tmp=extractString(work);
  if(!tmp.isNull()) {
    int v=tmp.toInt();
    finalstr += "<br><b> Speed: </b>";
    finalstr += convertSpeed(v);
  }

  finalstr += "<br><b> Client:   </b>";
  finalstr += extractString(work);

// may also have some extra stuff if we are admin or higher
  tmp=extractString(work);
  if(!tmp.isNull())
  {
    finalstr += "<br><b> Total uploads:   </b>";
    finalstr += tmp; 

    finalstr += "<br><b> Total downloads:   </b>";
    finalstr += extractString(work); 

    finalstr += "<br><b> IP Address:   </b>";
    finalstr += extractString(work); 

    finalstr += "<br><b> Connection Port:   </b>";
    finalstr += extractString(work); 

    finalstr += "<br><b> Port:   </b>";
    finalstr += extractString(work); 
    
    finalstr += "<br><b> Email address:   </b>";
    finalstr += extractString(work); 
    
  }
  infolabel->setText(finalstr);

  return;
}
// convert s seconds into a duration - take into account minutes
// // and hours and create a string as appropriate
QString KNAP_Whois::convertSecondsToDurationString(long s)
{
   QString str;

   str= QString().setNum(s%60) + "s";
   if(s) {
      s/=60;
      if(s) {
	 str= QString().setNum(s%60) + "m :" + str;
	 s/=60;
      }
      if(s) {
	 str= QString().setNum(s) + "h, " + str;
      }
   }

   return str;
} 
