/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef NETWORKDEVICESDIALOG_H
#define NETWORKDEVICESDIALOG_H

#include <qwidget.h>
#include <qpoint.h>
#include <qiconview.h>
#include <qtimer.h>
#include <qmutex.h>
#include <qpopupmenu.h>


#include "knetdockif.h"
#include "wifiscandialog.h"
#include "devicestatdialog.h"

typedef QDict<DeviceStatDialog> DevStatList;


class NetworkDevicesDialog : public QWidget
{
  Q_OBJECT

public:
  NetworkDevicesDialog(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~NetworkDevicesDialog();


public slots:
	void firstQueryCompleted();

	void runDHCPClient();
	void wifiScan();

	void toggleBPS();
	void walletClosed();
	
	void devAdded(const QString& dev_name);
	void devRemoved(const QString& dev_name);
	void devUpdated(const QString& dev_name);

	void showDeviceMenu(QIconViewItem *, const QPoint &);

	void showDetails();

	void removeDetails(const QString& dev_name);
	
	void updateIconView(const KNetDockIf* nif, QIconViewItem *i);
	virtual bool close(bool mode);
	
	bool readState(const QString& dev_name);
	void saveDockState(const QString& dev_name, bool mode);

	void quitAll();
	void bringUp();
	void bringDown();
	void doConfig();

private:
	void showDetails(const QString& dev_name, bool show_dock);
	QTimer *timer;
	QPopupMenu *devmenu;
	QMutex mutex;
	QIconView *dev_icons;

	int bitsMenuID;
	int scanMenuID;
	WifiScanDialog *wifi_scan;
	DevStatList stat_list;
	const QString runSUCmd(const QString& cmd_bin, const QString& cmd_params);
};

#endif

