/***************************************************************************
                                 popup.cpp
                             -------------------                                         
    begin                : Tue Sep 7 1999                                           
    copyright            : (C) 1999 by Markus Gustavsson                         
    email                : mighty@fragzone.se                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "popup.h"

PopUp::PopUp(QWidget *parent, const char *name) : QWidget(parent,name)
{
	KWin::setType(winId(), NET::Override);
	KWin::setState(winId(), NET::Sticky | NET::SkipTaskbar | NET::StaysOnTop);

	resize(290, 50);

	str = (char *) calloc(256, sizeof(char));
	strcpy(str, "??\n??");

	relX = 0;
	relY = 0;

	isDragged = FALSE;
}

PopUp::~PopUp()
{
	free(str);
}

void PopUp::setText(const char *ptr)
{
	strcpy(str, ptr);
	repaint();
}

void PopUp::paintEvent(QPaintEvent *Event)
{
	Event = (QPaintEvent *) 0;
	QPainter p(this);

	p.fillRect(0, 0, 290, 50, QBrush(QColor((isDragged) ? QColor(0, 0, 255) : QColor(0, 0, 100))));
	p.fillRect(2, 2, 286, 46, QBrush(QColor(235, 235, 255)));

	p.setFont(QFont("Helvetica", 12));
	p.setPen(QColor(0, 0, 0));
	p.drawText(rect(), AlignHCenter | AlignVCenter, str);
}

void PopUp::mousePressEvent(QMouseEvent *Event)
{
	if(Event->button() == RightButton) emit clicked();
	else {
		isDragged = TRUE;
		relX = Event->x();
		relY = Event->y();
		repaint();
	}
}

void PopUp::mouseReleaseEvent(QMouseEvent *Event)
{
	Event = (QMouseEvent *) 0;
	isDragged = FALSE;
	repaint();
	emit savePos();
}

void PopUp::mouseMoveEvent(QMouseEvent *Event)
{
	move(Event->globalX() - relX, Event->globalY() - relY);
}















