/***************************************************************************
                          board_2d.h  -  description
                             -------------------
    begin                : Fri Feb 28 2003
    copyright            : (C) 2003 by The Knights Project
    email                : knights-general@lists.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BOARD_2D_H
#define BOARD_2D_H

#include <board_base.h>
#include <qpixmap.h>
#include <qptrlist.h>

/**
  *@author The Knights Team
  */

typedef struct sprite
{
	bool Restore;
	int Steps;
	int POSITION_Origin;
	int POSITION_Destination;
	int POSITION_TargetTaken;
	QPoint POINT_Origin;
	QPoint POINT_Current;
	QPoint POINT_LastUpdate;
	QPoint POINT_Destination;
	QPixmap PIXMAP_Sprite;
	QPixmap PIXMAP_FlipFrame;
};

typedef QPtrList<sprite> SpriteList;
class KnightsPixCache;

class board_2d : public board_base
{
	Q_OBJECT
	public: 
											board_2d(QWidget *parent=0, const char *name=0, resource *Rsrc=0, logic *Lgc=0);
											~board_2d();
		virtual void			drawMove( const ChessMove &chessMove, const bool &reverse=FALSE );
		virtual void			setPremovePositions( const int&, const int& );
		virtual void			redrawLights( void );
		void							paintEvent( QPaintEvent *event );
		void							mouseReleaseEvent( QMouseEvent *event );
		void							mousePressEvent( QMouseEvent *event );
		void							mouseMoveEvent( QMouseEvent *event );

	public slots:
		virtual void			resizeBoard( void );
		virtual void			redrawAll( void );
		virtual void			drawPosition( const int& );
		virtual void			commit( void );

	protected:
		void							drawCoords( QPixmap *pic, const int &pos );
		QPoint						coords( const int&, const int&);
		int								position( const QPoint& );
		void							drawSprites( void );
		QPixmap						getChessman( const int &pos );
		bool							isSprite( const int &pos );
		void							myBlit( const QPoint &dp, const QPaintDevice *src, const QRect &sr );

	protected slots:
		void							updateSprites( void );

	private:
		SpriteList				sprites;
		sprite						*DragSprite;
		KnightsPixCache		*cache;
		QPixmap						myself;
		QPoint						pressPoint;
		bool							orientation;
		bool							lastMoveWasDrag;
		bool							init;

		int								updateX1;
		int								updateY1;
		int								updateX2;
		int								updateY2;

		/* Premove Positions */
		int								premoveFrom;
		int								premoveTo;
};

#endif
