// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#include "hk_kdepreferencesdialog.h"
#include <hk_class.h>
#include <hk_drivermanager.h>
#include <qfontdatabase.h>

#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <klocale.h>
#include <kapplication.h>
#include <kconfig.h>

hk_kdepreferencesdialog::hk_kdepreferencesdialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
: hk_kdepreferencesdialogbase( parent, name, modal, fl )
{

    datelabel->setText( i18n( "Date format:"  ) );
    timelabel->setText( i18n( "Time format:"  ) );
    datetimelabel->setText( i18n( "Date&Time format:"  ) );
    setCaption( i18n( "Preferences"  ) );
    regionaltab->changeTab(regionalpage,i18n("&Regional"));
    regionaltab->changeTab(printerpage,i18n("&Printer"));
    regionaltab->changeTab(generalpage,i18n("&General"));
    driverpathlabel->setText( i18n( "Driverpath:"  ) );
    encodinglabel->setText( i18n( "Fontencoding:"  ) );
    printcommandlabel->setText( i18n( "Printcommand:"  ) );
    bepedanticlabel->setText( i18n( "Show all questions:"  ) );
    maximizedlabel->setText( i18n( "Show maximized:"  ) );
    fontlabel->setText(i18n("Default Font:"));
    defaultdriverlabel->setText(i18n("Default driver:"));
    QFontDatabase*p_fontdatabase = new QFontDatabase();
    QStringList strlist=p_fontdatabase->families();
    QStringList newstrlist;
    for (QStringList::iterator it=strlist.begin();it!=strlist.end();++it)
    {
        QString f=(*it);
        int pos= f.find("[",0);
        if (pos!=-1) f.truncate(pos-1);
	// eliminate fonts with a space in the name
	pos=f.find(" ",0);
	
        if (!newstrlist.contains(f)&&pos==-1) 
	   newstrlist.append(f);
    }

    fontfield->insertStringList(newstrlist);
    delete p_fontdatabase;
    QString left=i18n("Left");
    QString right=i18n("Right");
    QString center=i18n("Center");
    textalignmentfield->insertItem(left);
    textalignmentfield->insertItem(center);
    textalignmentfield->insertItem(right);

    numberalignmentfield->insertItem(left);
    numberalignmentfield->insertItem(center);
    numberalignmentfield->insertItem(right);
    textalignmentlabel->setText(i18n("Text alignment:"));
    numberalignmentlabel->setText(i18n("Number alignment:"));
    separatorlabel->setText(i18n("Separator:"));
    precisionlabel->setText(i18n("Precision:"));
    QString yes=i18n("Yes");
    QString no=i18n("No");
    bepedanticfield->insertItem(yes);
    bepedanticfield->insertItem(no);
    maximizedfield->insertItem(yes);
    maximizedfield->insertItem(no);
    separatorfield->insertItem(yes);
    separatorfield->insertItem(no);
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("Preferencesdialog");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);

}


hk_kdepreferencesdialog::~hk_kdepreferencesdialog()
{
// no need to delete child widgets, Qt does it all for us
}


void hk_kdepreferencesdialog::driverpathbutton_clicked()
{
//cout <<"driverpathbutton_clicked"<<endl;
    hk_drivermanager::show_driverselectdialog();
    driverpathfield->setText(hk_drivermanager::path().c_str());

}



void hk_kdepreferencesdialog::accept(void)
{
KConfig* c=kapp->config();
  c->setGroup("Preferencesdialog");
  c->writeEntry("Geometry",geometry());
QDialog::accept();
}
