// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.28 $

#include <hk_kderowselector.h>
#include <hk_kderowselector.moc>
#include <qtooltip.h>
#include <qstyle.h>
#include <qrect.h>
#include <klocale.h>
#include <kapp.h>
#include <qpainter.h>
#include <qdrawutil.h>
#include <qnamespace.h>
#include <qsizepolicy.h>
#include <qtooltip.h>
#include <hk_form.h>
#include <hk_kdeform.h>

class farleftbutton:public QPushButton
{
    public:
        farleftbutton( QWidget* wid):QPushButton(wid){  setFocusPolicy(ClickFocus);}
    protected:
        virtual void drawButtonLabel(QPainter* p)
        {
            int x,y,w,h;
            x=4;
            y=3;
            w=width()-5;h=height()-5;
            int Lx =w / 2 ;
            int Ly= h/2 ;
            if (isDown()){x++;y++;Lx++;Ly++;}
            Ly--;
            style().drawPrimitive(QStyle::PE_ArrowLeft,p,QRect(x,y,w,h),colorGroup(),isEnabled()?QStyle::Style_Enabled:QStyle::Style_Default);
            int l=7;
            QPen newpen =p->pen();
            newpen.setWidth(2);
            p->setPen(newpen);
            if (!isEnabled())p->setPen(colorGroup().light());
            else   p->setPen(colorGroup().buttonText());
            p->drawLine(Lx,Ly,Lx,Ly+l);

        }
    private:
}


;
class leftbutton:public QPushButton
{
    public:
        leftbutton( QWidget* wid):QPushButton(wid){ setFocusPolicy(ClickFocus);}
    protected:
        virtual void drawButtonLabel(QPainter* p)
        {
            int x,y,w,h;
            x=4;
            y=3;
            w=width()-8;h=height()-5;
            int Lx =w / 2 -2;
            int Ly= h/2 ;
            if (isDown()){x++;y++;Lx++;Ly++;}
            style().drawPrimitive(QStyle::PE_ArrowLeft,p,QRect(x,y,w,h),colorGroup(),isEnabled()?QStyle::Style_Enabled:QStyle::Style_Default);
        }
    private:
}


;
class rightbutton:public QPushButton
{
    public:
        rightbutton( QWidget* wid):QPushButton(wid){ setFocusPolicy(ClickFocus);}
    protected:
        virtual void drawButtonLabel(QPainter* p)
        {
            int x,y,w,h;
            x=4;
            y=3;
            w=width()-8;h=height()-5;
            int Lx =w / 2 -2;
            int Ly= h/2 ;
            if (isDown()){x++;y++;Lx++;Ly++;}
            style().drawPrimitive(QStyle::PE_ArrowRight,p,QRect(x,y,w,h),colorGroup(),isEnabled()?QStyle::Style_Enabled:QStyle::Style_Default);
        }
    private:
}


;
class farrightbutton:public QPushButton
{
    public:
        farrightbutton( QWidget* wid):QPushButton(wid){ setFocusPolicy(ClickFocus);}
    protected:
        virtual void drawButtonLabel(QPainter* p)
        {
            int x,y,w,h;
            x=4;
            y=3;
            w=width()-10;h=height()-5;
            int Lx =w / 2 +7;
            int Ly= h/2 ;
            if (isDown()){x++;y++;Lx++;Ly++;}
            Ly--;
            style().drawPrimitive(QStyle::PE_ArrowRight,p,QRect(x,y,w,h),colorGroup(),isEnabled()?QStyle::Style_Enabled:QStyle::Style_Default);
            int l=7;
            QPen newpen =p->pen();
            newpen.setWidth(2);
            p->setPen(newpen);
            if (!isEnabled())p->setPen(colorGroup().light());
            else   p->setPen(colorGroup().buttonText());
            p->drawLine(Lx,Ly,Lx,Ly+l);

        }
    private:
}


;

class deletebutton:public QPushButton
{
    public:
        deletebutton( QWidget* wid):QPushButton(wid){ setFocusPolicy(ClickFocus);}
    protected:
        virtual void drawButtonLabel(QPainter* p)
        {
            int x,y,w,h;
            x=2;y=2;w=width();h=height();
            int Lx =w / 2 -3;
            int Ly= h/2 ;
            if (isDown()){x++;y++;Lx++;Ly++;}
            int l=5;
            QPen newpen =p->pen();
            newpen.setWidth(2);
            p->setPen(newpen);
            if (!isEnabled())p->setPen(colorGroup().light());
            else   p->setPen(colorGroup().buttonText());
            p->drawLine(Lx,Ly,Lx+l,Ly);
        }
    private:
}


;

class addbutton:public QPushButton
{
    public:
        addbutton( QWidget* wid):QPushButton(wid){ setFocusPolicy(ClickFocus);}
    protected:
        virtual void drawButtonLabel(QPainter* p)
        {
            int x,y,w,h;
            x=2;y=2;w=width();h=height();
            int Lx =w / 2 -3;
            int Ly= h/2 ;
            if (isDown()){x++;y++;Lx++;Ly++;}
            int l=5;
            if (!isEnabled())p->setPen(colorGroup().light());
            else   p->setPen(colorGroup().buttonText());
            QPen newpen =p->pen();
            newpen.setWidth(2);
            p->setPen(newpen);
            p->drawLine(Lx,Ly,Lx+l+1,Ly);
            p->drawLine(w/2,Ly-3,w/2,Ly+3);
        }
    private:
}


;

class storebutton:public QPushButton
{
    public:
        storebutton( QWidget* wid):QPushButton(wid){ setFocusPolicy(ClickFocus);}
    protected:
        virtual void drawButtonLabel(QPainter* p)
        {
            int x,y,w,h;
            x=2;y=2;w=width();h=height();
            int Lx =w / 2 -3;
            int Ly= h/2 ;
            if (isDown()){x++;y++;Lx++;Ly++;}
//		int l=5;
            if (!isEnabled())p->setPen(colorGroup().light());
            else   p->setPen(colorGroup().buttonText());
            QPen newpen =p->pen();
            newpen.setWidth(2);
            p->setPen(newpen);
            p->drawText(Lx+2,Ly+5,"!");
        }
    private:
}


;

hk_kderowselector::hk_kderowselector(QWidget* wid,hk_form* form) :
QWidget(wid),hk_dsrowselector(form)
{
#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::hk_kderowselector");
#endif
    QSizePolicy policy(QSizePolicy::Preferred,QSizePolicy::Preferred);
    button_delete= new deletebutton(this);
    button_gotofirst= new farleftbutton(this);
    button_gotoprevious= new leftbutton(this);
    button_gotonext= new rightbutton(this);
    button_gotolast= new farrightbutton(this);
    button_store= new storebutton(this);
    button_insert= new addbutton(this);
    button_delete->setSizePolicy(policy);
    button_gotofirst->setSizePolicy(policy);
    button_gotolast->setSizePolicy(policy);
    button_gotonext->setSizePolicy(policy);
    button_gotoprevious->setSizePolicy(policy);
    button_store->setSizePolicy(policy);
    button_insert->setSizePolicy(policy);

    QToolTip::add(button_gotofirst,i18n("Goto first"));
    QToolTip::add(button_gotoprevious,i18n("Goto previous"));
    QToolTip::add(button_gotonext,i18n("Goto next"));
    QToolTip::add(button_gotolast,i18n("Goto last"));
    QToolTip::add(button_store,i18n("Store changes"));
    QToolTip::add(button_delete,i18n("Delete row"));
    QToolTip::add(button_insert,i18n("Insert new row"));
    label= new KLineEdit(this);
    label->setSizePolicy(policy);
    label->setFocusPolicy(ClickFocus);
    layout= new QHBoxLayout(this);
    layout->addWidget(button_delete,1);
    layout->addWidget(button_gotofirst,1);
    layout->addWidget(button_gotoprevious,1);
    layout->addWidget(label,3);
    layout->addWidget(button_gotonext,1);
    layout->addWidget(button_gotolast,1);
    layout->addWidget(button_store,1);
    layout->addWidget(button_insert,1);
    layout->activate();
    layout->setEnabled(true);
    setFocusProxy(label);

    QColor qcolor=button_gotofirst->paletteBackgroundColor();
    hk_colour colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_backgroundcolour(colour,false,true);
    qcolor=button_gotofirst->paletteForegroundColor();
    colour.set_colour(qcolor.red(),qcolor.green(),qcolor.red());
    set_foregroundcolour(colour,false,true);

    QObject::connect(button_gotofirst,SIGNAL(clicked()),this,SLOT(slotpress_gotofirst()));
    QObject::connect(button_gotoprevious,SIGNAL(clicked()),this,SLOT(slotpress_gotoprevious()));
    QObject::connect(button_gotonext,SIGNAL(clicked()),this,SLOT(slotpress_gotonext()));
    QObject::connect(button_gotolast,SIGNAL(clicked()),this,SLOT(slotpress_gotolast()));
    QObject::connect(button_insert,SIGNAL(clicked()),this,SLOT(slotpress_insert()));
    QObject::connect(button_delete,SIGNAL(clicked()),this,SLOT(slotpress_delete()));
    QObject::connect(button_store,SIGNAL(clicked()),this,SLOT(slotpress_storechanges()));
    QObject::connect(label,SIGNAL(returnPressed()),this,SLOT(slotlineedit()));
    widget_specific_enable_disable();
}


hk_kderowselector::~hk_kderowselector()
{
#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::~hk_kderowselector");
#endif
    delete layout;
    delete button_gotofirst;
    delete button_gotoprevious;
    delete button_gotonext;
    delete button_gotolast;
    delete label;
    delete button_delete;
    delete button_insert;

}


void hk_kderowselector::slotpress_gotofirst(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::slotpress_gotofirst");
#endif
    emit rowselector_clicked();
    emit firstrow_clicked();
    if (datasource()!=NULL)
        datasource()->goto_first();

}


void hk_kderowselector::slotpress_gotoprevious(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::slotpress_gotoprevious");
#endif
    emit rowselector_clicked();
    emit previousrow_clicked();
    if (datasource()!=NULL)
        datasource()->goto_previous();
}


void hk_kderowselector::slotpress_gotonext(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::slotpress_gotonext");
#endif
    emit rowselector_clicked();
    emit nextrow_clicked();

    if (datasource()!=NULL)
        datasource()->goto_next();
}


void hk_kderowselector::slotpress_gotolast(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::slotpress_gotolast");
#endif
    emit rowselector_clicked();
    emit lastrow_clicked();
    if (datasource()!=NULL)
        datasource()->goto_last();

}


void hk_kderowselector::slotpress_storechanges(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::slotpress_storechanges");
#endif
    if (datasource()!=NULL)
    {
        if (datasource()->is_enabled())
            datasource()->store_changed_data();
    }

}


void hk_kderowselector::slotpress_insert(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::slotpress_insert");
#endif
    emit rowselector_clicked();
    emit insertrow_clicked();

    if (datasource()!=NULL)
    {
//datasource()->mode(mode_insertrow);
        datasource()->setmode_insertrow();
    }

}


void hk_kderowselector::slotpress_delete(void)

{
#ifdef HKDEBUG
    hkdebug("hk_kderowselector::slotpress_delete");
#endif
    emit rowselector_clicked();
    emit deleterow_clicked();

    if (datasource()!=NULL)
    {
//datasource()->mode(mode_deleterow);
        datasource()->delete_actualrow();
    }

}


void hk_kderowselector::slotlineedit()
{
#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::slotlineedit");
#endif
    emit rowselector_clicked();

    if (datasource()!=NULL)
        datasource()->goto_row(atoi(label->text())-1);

}


void hk_kderowselector::widget_specific_enable_disable(void)
{
    unsigned long p,q;
#ifdef HK_DEBUG
    hkdebug("kderowselector::widget_specific_enable_disable");
#endif
    if (datasource()==NULL)
    {
        button_gotofirst->setEnabled(false);
        button_gotoprevious->setEnabled(false);
        button_gotonext->setEnabled(false);
        button_gotolast->setEnabled(false);
        button_store->setEnabled(false);
        button_delete->setEnabled(false);
        button_insert->setEnabled(false);
        label->setText("");
        label->setEnabled(false);

        return;
    }

// change enable/disable

    p=datasource()->row_position();
    q=datasource()->max_rows();
//insertmode
    if (datasource()->mode()==hk_datasource::mode_insertrow)
    {
        button_gotofirst->setEnabled(false);
        button_gotoprevious->setEnabled(false);
        button_gotonext->setEnabled(false);
        button_gotolast->setEnabled(false);
        button_delete->setEnabled(false);
        return;
    }
// normalmode;
    unsigned long  buf;
    char* s= new char[50];

    if (datasource()!=NULL) buf=datasource()->row_position(); else buf=0;
    sprintf(s,"%lu",buf+1);
    label->setText(s);
    delete[] s;

    if ((buf==0)||((!datasource()->is_enabled())))
    {
        button_gotofirst->setEnabled(false);
        button_gotoprevious->setEnabled(false);
    }
    else
    {
        button_gotofirst->setEnabled(true);
        button_gotoprevious->setEnabled(true);
    }

    if ((p==q-1)||(!datasource()->is_enabled()))
    {
        button_gotonext->setEnabled(false);
        button_gotolast->setEnabled(false);
    }
    else
    {
        button_gotonext->setEnabled(true);
        button_gotolast->setEnabled(true);
    }
    if (!datasource()->is_enabled())label->setText(" ");
    label->setEnabled(datasource()->is_enabled());
    if ((datasource()->is_enabled())&&(!datasource()->is_readonly()&&!is_readonly()))
    {
        button_delete->setEnabled(true);
        button_insert->setEnabled(true);
        button_store->setEnabled(true);
    }
    else
    {
        button_delete->setEnabled(false);
        button_insert->setEnabled(false);
        button_store->setEnabled(false);
    }
/* if (p_presentation!=NULL) if (p_presentation->state()==hk_form::design)
 {
    setFocusPolicy(NoFocus);
    setEnabled(true);
  }
  else */
    //setFocusPolicy(ClickFocus);

}


bool hk_kderowselector::widget_specific_row_change(void)
{
    unsigned long p;
#ifdef HK_DEBUG
    hkdebug("kderowselector::widget_specific_row_change");
#endif
    if (datasource()!=NULL) p=datasource()->row_position(); else p=0;

    label->setText(ulongint2string(p+1).c_str());
    widget_specific_enable_disable();
    return true;
}


void    hk_kderowselector::widget_specific_insert_mode(void)
{
    widget_specific_enable_disable();
}


void hk_kderowselector::datasource_delete(void)
{

#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::datasource_delete");
#endif
    hk_dsvisible::datasource_delete();
    widget_specific_enable_disable();
}


bool hk_kderowselector::datasource_enable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kderowselector::datasource_enable");
#endif
    widget_specific_row_change();
    return true;
}


bool hk_kderowselector::widget_specific_coordinates(uint px,uint py,uint pwidth,uint pheight)
{
    blockSignals(true);
    setGeometry(px,py,pwidth,pheight);
    blockSignals(false);
    return true;
}


void hk_kderowselector::resizeEvent ( QResizeEvent * event )
{
#ifdef HK_DEBUG
    hkdebug("kderowselector::resizeEvent");
#endif
    QWidget::resizeEvent(event);
    reposition();

}


void  hk_kderowselector::moveEvent ( QMoveEvent * event)
{
#ifdef HK_DEBUG
    hkdebug("kderowselector::resizeEvent");
#endif
    QWidget::moveEvent(event);
    reposition();
}


void hk_kderowselector::reposition(void)
{
#ifdef HK_DEBUG
    hkdebug("kderowselector::reposition");
#endif
    if (p_presentation==NULL ||p_setcoordinates==true) return;
    p_setwidgetcoordinates=true;
    unsigned int ppx=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QWidget::x()):QWidget::x();
    unsigned int ppy=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QWidget::y()):QWidget::y();
    unsigned int pph=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QWidget::height()):QWidget::height();
    unsigned int ppw=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QWidget::width()):QWidget::width();
    set_size(ppx,ppy,ppw,pph);
    p_setwidgetcoordinates=false;
}


void    hk_kderowselector::widget_specific_backgroundcolour_changed(const hk_colour&)
{
    hk_colour c=backgroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
// setPaletteBackgroundColor(newcolour);
    button_delete->setPaletteBackgroundColor(newcolour);
    button_insert->setPaletteBackgroundColor(newcolour);
    button_gotofirst->setPaletteBackgroundColor(newcolour);
    button_gotonext->setPaletteBackgroundColor(newcolour);
    button_gotoprevious->setPaletteBackgroundColor(newcolour);
    button_gotolast->setPaletteBackgroundColor(newcolour);
    button_store->setPaletteBackgroundColor(newcolour);

}


void    hk_kderowselector::widget_specific_foregroundcolour_changed(const hk_colour&)
{
    hk_colour c=foregroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteForegroundColor(newcolour);

    button_delete->setPaletteForegroundColor(newcolour);
    button_insert->setPaletteForegroundColor(newcolour);
    button_gotofirst->setPaletteForegroundColor(newcolour);
    button_gotonext->setPaletteForegroundColor(newcolour);
    button_gotoprevious->setPaletteForegroundColor(newcolour);
    button_gotolast->setPaletteForegroundColor(newcolour);
    button_store->setPaletteForegroundColor(newcolour);

}


void  hk_kderowselector::widget_specific_tooltip_changed(void)
{
 QToolTip::add(this,QString::fromLocal8Bit (tooltip().c_str()));
}




void hk_kderowselector::focusInEvent ( QFocusEvent * e)
{
  action_on_getfocus();
  QWidget::focusInEvent(e);
}

void hk_kderowselector::focusOutEvent ( QFocusEvent * e)
{
  action_on_loosefocus();
  QWidget::focusOutEvent(e);

}


