BEGIN;

CREATE TABLE access (
	id integer PRIMARY KEY DEFAULT nextval('seq_knowledge'),
	table_name varchar(255) DEFAULT '',
	belongs_to integer DEFAULT 0,
	owner_group varchar(5) DEFAULT '',
	owner_group_id integer DEFAULT 0,
	rights integer DEFAULT 0
);

ALTER TABLE files ADD COLUMN counter integer;
ALTER TABLE files ALTER COLUMN counter SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN symlink integer;
ALTER TABLE tree ALTER COLUMN symlink SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN sorting integer;
ALTER TABLE tree ALTER COLUMN sorting SET DEFAULT 0;

ALTER TABLE tree ADD COLUMN tooltip varchar(255);
ALTER TABLE tree ALTER COLUMN tooltip SET DEFAULT '';

ALTER TABLE settings ALTER COLUMN value TYPE text;

INSERT INTO extensions (keyname, active, admin) VALUES ('fckeditor', 1, 0);
INSERT INTO extensions (keyname, active, admin) VALUES ('tinymce', 0, 0);

INSERT INTO settings (name, value, description, selection) VALUES ('downloads.static', '0', 'enable static download links', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.order.self', '0', 'enable self ordering of tree elments', '');
INSERT INTO settings (name, value, description, selection) VALUES ('session.handle', '0', 'enable handling of sessin', '');
INSERT INTO settings (name, value, description, selection) VALUES ('session.lifetime', '60', 'lifetime of session in minutes', '');
INSERT INTO settings (name, value, description, selection) VALUES ('session.checkIP', '0', 'check ip of session', '');
INSERT INTO settings (name, value, description, selection) VALUES ('session.checkBrowser', '0', 'check browser of session', '');
INSERT INTO settings (name, value, description, selection) VALUES ('session.onlyCookies', '0', 'allow only cookie sessions', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.context', '1', 'enable/disable contextmenus', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.dragdrop', '1', 'enable/disable drag and drop in tree', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.recursivdelete', '2', 'set recusriv delete, 2 - only admins; 1 - all users with login, 0 - all users', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.edittooltiptext', '0', 'enable/disable edit of tooltiptext of tree element', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.showcounter', '1', 'enable/disable counting of tree items', '');
INSERT INTO settings (name, value, description, selection) VALUES ('content.showcounter', '1', 'enable/disable counting of content items', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.defaultlayout', '0', 'enable/disable a default layout of the tree', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.defaultlayoutarray', '', 'serialized array with default layout of tree - should not be edit', '');
INSERT INTO settings (name, value, description, selection) VALUES ('menu.showsourceforgelogo', '0', 'show sourceforge logo', '');
INSERT INTO settings (name, value, description, selection) VALUES ('knowledgeroot.showlogo', '0', 'show knowledgeroot logo instead of texttitle', '');
INSERT INTO settings (name, value, description, selection) VALUES ('version', '0.9.9', 'knowledgeroot version - do not edit! - it only shows the database version of knowledgeroot', '');
INSERT INTO settings (name, value, description, selection) VALUES ('baseurl', '', 'base url for knowledgeroot', '');

COMMIT;
