/***************************************************************************
                          knutmessagemanager.h  -  description
                             -------------------
    begin                : So led 24 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTMESSAGEMANAGER_H
#define KNUTMESSAGEMANAGER_H

#include "knutmessage.h"

#include <qobject.h>

/**
  *@author Daniel Prynych
  */

namespace knc {
  
enum LevelOfMessage {
  infoLevel,    // status RB, TRIM, CAL, TRIM
  lowWarningLevel, // OVER,
  warningLevel, // OB ..
  errorLevel,   // connection error
  criticalLevel // Status BL, OFF
  };

 }

class QString;
            
/**
 * Tato trida slouzi pro ovladani vyskakovacich oken (pop-up)
 * Okno pracuji nezavisle na ostatnich oknech a NEPOZASTAVUJI jejich cinnost.
 *
 * @author Daniel Prynych
 * @short window message manager
 * @version 0.1
  */
class KNutMessageManager : public QObject  {
    Q_OBJECT
  public:
/**
 * Konstruktor - vytvori instanci tridy.
 *
 * @since  0.1
 */
  KNutMessageManager(  QObject *parent=0, const char *name=0);

/**
 * Destruktor.
 *
 * @since  0.1.1
 **/
  ~KNutMessageManager();

/**
 * Pozada o zobrazeni okna. Pokud je zobrazeno okne s vyssi prioritou, neni funkce provedena.
 *
 * @param  text Text zpravy ktera se zobrazi v okne.
 * @param messageLevel urcuje prioritu zpravy.
 * @param useInfoIcon urcuje ktera icona se zobrazi. Pokud je nastaven na true, je vzdy zobrazena icona
 * info, pokud je false je nastavena icona v zavislosti na priorite zpravy.
 *
 * @since  0.1
 **/
  void addMessage (QString text, knc::LevelOfMessage messageLevel = knc::infoLevel, bool useInfoIcon = false);


/**
 * Zrusi okno, pokud existuje;
 *
 * @since  0.1.1
 **/
  void deleteMessage (void);

  
  private slots:

/**
 * @internal
 * Je aktivovan, kdyz bylo pozadano o zruseni okna stsknutim praveho widgetu nebo vnejsimi udalostmi (KDE Logout).
 *
 * @since  0.1.2
 **/
  void slotFinishedMessage (void);

/**
 * @internal
 * Je aktivovan, kdyz bylo pozadano o zruseni okna stsknutim OK nebo vyprsenim casoveho terminu
 *
 * @since  0.1.2
 **/
  void slotEndMessage (void);
  
  private:

  static const long int TimeOfValidity = 600;
  KNutMessage* myMess;
  knc::LevelOfMessage myMessLevel;
  };

#endif
