/***************************************************************************
 *   Copyright (C) 2006 by Sergio Cambra   *
 *   sergio@ensanjose.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qlayout.h>

#include <klocale.h>
#include <kglobal.h>
#include <kparts/genericfactory.h>
#include <kaboutdata.h>

#include "kcmkommando.h"
#include "configdialogimpl.h"
#include "configuration.h"

static const char description[] =
    I18N_NOOP("A wheelmenu for KDE powerusers");

static const char version[] = "0.5.0";

typedef KGenericFactory<KCMKommando, QWidget> kommandoFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kommando, kommandoFactory("kcmkommando"))

KCMKommando::KCMKommando(QWidget *parent, const char *name, const QStringList&)
	: KCModule(parent, name), about(0), configDialog(0)
{
	about = new KAboutData("kommando", I18N_NOOP("Kommando"), version, description,
					 KAboutData::License_GPL, "(C) 2005 Daniel StÃ¶ckel", 0, 0, "the_docter@gmx.net");
	about->addAuthor( "Daniel StÃ¶ckel", 0, "the_docter@gmx.net" );
	about->addAuthor( "Sergio Cambra", 0, "runico@users.berlios.de" );
	setAboutData(about);
	
	QVBoxLayout* layout = new QVBoxLayout( this );
	layout->setAutoAdd( true );
	configDialog = new ConfigDialogImpl(this);
	connect(configDialog, SIGNAL(changed(bool)), this, SLOT(configChanged(bool)));
    load();
};


KCMKommando::~KCMKommando()
{
}


void KCMKommando::load()
{
	Config& config = Config::getSingleton();
    config.readConfigFile();
    configDialog->readConfig();
    emit changed(false);
}


void KCMKommando::defaults()
{
	configDialog->slotDefaultsClicked();
    emit changed(true);
}


void KCMKommando::save()
{
	configDialog->slotApplyClicked();
    emit changed(false);
}


int KCMKommando::buttons()
{
    return KCModule::Default|KCModule::Apply|KCModule::Help;
}


QString KCMKommando::quickHelp() const
{
    return i18n("Helpful information about the prueba module.");
}

#include "kcmkommando.moc"
