/***************************************************************************
 *   Copyright (C) 2005-2006 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KLISTVIEWITEMSINGLE_H_
#define _KLISTVIEWITEMSINGLE_H_

#include <qlistview.h>

class KListView;
class KFileItemExt;
class QPainter;
class QColorGroup;
class QColor;

enum FILTER
{
	NONE = 0,
	NAME = 1,
	PATH = 2,
	OWNER = 4,
	GROUP = 8,
	SIZE = 16,
	DATE = 32,
	NEWER_REAL = 64,
	NEWER_EQUAL = 128,
	NEWER_SAME_TIME = 256,
	DUPLICATES_NORMAL = 512,
	DUPLICATES_MULTIPLE = 1024
};

class KListViewItemSingle : public QListViewItem
{
	public:
		KListViewItemSingle( KListView *parent, KFileItemExt *_item, KListViewItemSingle *_brother );
		~KListViewItemSingle();

		QString key( int column, bool ) const;

		void paintCell ( QPainter *p, const QColorGroup &cg, int column, int width, int alignment );
		void setKind( FILTER kind, const QColor &color = QColor( 0, 0, 0 ) );
		int kind();

		void addFilter( FILTER filter );
		void removeFilter( FILTER filter );
		void setVisibility();

		KFileItemExt *item;
		KListViewItemSingle *brother;

	private:
		int m_filter;
		int m_kind;
		QColor m_color;
};

#endif
