/***************************************************************************
 *   Copyright (C) 2005-2008 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qdatetime.h>

#include <kglobal.h>
#include <klocale.h>
#include <kmdcodec.h>

#include "kfileitemext.h"

#include "klistviewitemsingle.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

KListViewItemSingle::KListViewItemSingle( KListView *parent, KFileItemExt *_item, KListViewItemSingle *_brother )
	: QListViewItem( (QListView*)parent ), m_filter( NONE ), m_kind( NONE )
{
	item = _item;

	brother = _brother;
	m_color = Qt::black;
	m_use_color = true;

	QDateTime dt;
	dt.setTime_t( item->time( KIO::UDS_MODIFICATION_TIME ) );
	QString date = KGlobal::locale()->formatDateTime( dt );

	// Fill the item with data
	setText( 0, KIO::decodeFileName( item->url().fileName() ) );
	setText( 1, "" ); // the directory is set individually, depending on the directory
		// we're in (it is stripped, and only subdirectories are displayed)
	setText( 2, /*KGlobal::locale()->formatNumber( item->size(), 0 )*/KIO::convertSize( item->size() ) ); // Beautiful size instead of bytes
	setText( 3, date );
	setText( 4, item->permissionsString() );
	setText( 5, item->user() );
	setText( 6, item->group() );

	// put the icon into the leftmost column
	setPixmap( 0, item->pixmap( 16 ) );
}

KListViewItemSingle::~KListViewItemSingle()
{
}

QString KListViewItemSingle::key( int column, bool ) const
{
	switch ( column )
	{
		case 2:  // Returns size in bytes. Used for sorting
			return QString().sprintf( "%010d", (uint)item->size() );
		case 3:  // Returns time in secs from 1/1/1970. Used for sorting
			return QString().sprintf( "%010ld", item->time( KIO::UDS_MODIFICATION_TIME ) );
		case 7: // Reference directory. Don't sort by the name of it, but by the dir number.
			return QString().sprintf( "%d", item->dir );
	}
	return text( column );
}

void KListViewItemSingle::paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int alignment )
{
	if ( m_color != Qt::black && m_use_color ) // If m_color is Qt::black, we want the default color of the desktop theme, otherwise we want our special colors
	{
		QColorGroup tmpcolorgroup( cg );

		tmpcolorgroup.setColor( QColorGroup::Text, m_color );
		tmpcolorgroup.setColor( QColorGroup::HighlightedText, QColor( 255-m_color.red(), 255-m_color.green(), 255-m_color.blue() ) ); // complementary color
		QListViewItem::paintCell( p, tmpcolorgroup, column, width, alignment );
	}
	else
	{
		QListViewItem::paintCell( p, cg, column, width, alignment );
	}
}

void KListViewItemSingle::setKind( FILTER kind, bool use_color, const QColor &color )
{
	m_kind = kind;
	m_color = color;
	m_use_color = use_color;
}

int KListViewItemSingle::kind()
{
	return m_kind;
}

QColor KListViewItemSingle::color()
{
	return m_color;
}

void KListViewItemSingle::addFilter( FILTER filter )
{
	m_filter |= filter;
}

void KListViewItemSingle::removeFilter( FILTER filter )
{
	if ( m_filter & filter ) m_filter ^= filter;
}

void KListViewItemSingle::setVisibility()
{
	setVisible( ( m_filter != NONE ) ? false : true );
}
