/***************************************************************************
                          useradd.cpp  -  description
                             -------------------
    begin                : Sun Jan 9 2000
    copyright            : (C) 2000 by Seth Hartbecke
    email                : gandalf@netins.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "useradd.h"

UserAdd *UserAdd::currentWindow;

UserAdd::UserAdd(QWidget *parent, const char *name )
	: KWizard(parent,name)
{
        setIcon( KGlobal::iconLoader()->loadIcon("useradd_dlg", KIcon::User) );

        firstPage = new UserAddPg1( this, "Test page" );
        addPage( firstPage, "Add new user" );
        firstPage->clickIKnowID();

        resize( 400, 300 );
        setCaption( "Add a buddy - Konverse" );
}

UserAdd::~UserAdd()
{
        currentWindow = 0;
}

void UserAdd::showUserAdd()
{
        if (!currentWindow)
        {
                currentWindow = new UserAdd( 0, 0 );
                currentWindow->show();
        }
}

void UserAdd::accept()
{
        UserAddPgChooseGroup *lastPage = (UserAddPgChooseGroup *)page( pageCount() -1 );
        lastPage->addThisUser();

        delete this;
}

void UserAdd::reject()
{
        delete this;
}

/*
        ==============================================================
                                UserAddTemplate
        ==============================================================
*/
UserAddTemplate::UserAddTemplate( KWizard *_parent, const char *name )
        : QWidget( _parent, name )
{
        topLayout = new QGridLayout(this, 1, 2, 3, -1, "layoutThingy");

        konverseLogoContainer = new QVBox( this, 0 );
        konverseLogoContainer->setBackgroundColor( *(new QColor( 255, 255, 255 )) );

        QPixmap logo;
	logo = KGlobal::iconLoader()->loadIcon("konverse-large", KIcon::NoGroup);
	konverseLogo = new QWidget( konverseLogoContainer, "Konverse Logo");
	konverseLogo->setBackgroundPixmap( logo );
	konverseLogo->resize( logo.size() );
	konverseLogo->setMaximumSize( logo.size() );
	konverseLogo->setMinimumSize( logo.size() );
        konverseLogoContainer->setMinimumHeight( logo.size().height() );
        konverseLogoContainer->setMinimumWidth( logo.size().width() );
        konverseLogoContainer->setMaximumWidth( logo.size().width() );
        topLayout->addWidget( konverseLogoContainer, 0, 0 );
        topLayout->setColStretch( 1, 2);

        form = new QWidget( this, "datapart" );
        topLayout->addWidget( form, 0, 1 );

        topLayout->activate();

        parent = _parent;
}

UserAddTemplate::~UserAddTemplate()
{
        delete topLayout;

        delete konverseLogo;
        delete konverseLogoContainer;
        delete form;
}

/*
        ==============================================================
                                UserAddTemplate
        ==============================================================
*/
UserAddPg1::UserAddPg1( KWizard *parent, const char *name )
        : UserAddTemplate( parent, name )
{
        topLayout = new QGridLayout( form, 4, 3 );

        topLayout->setColStretch( 0, 2 );
        topLayout->setColStretch( 2, 2 );
        topLayout->setRowStretch( 0, 2 );
        topLayout->setRowStretch( 3, 2 );

        btnKnowId = new QRadioButton( "I know the ID of my buddy", form, "knowid" );
        btnKnowId->setMaximumSize( btnKnowId->sizeHint() );
        btnKnowId->setMinimumSize( btnKnowId->sizeHint() );
        topLayout->addWidget( btnKnowId, 1, 1, AlignLeft );

        btnSearch = new QRadioButton( "Sorry, I forgot his/her ID\nand need to search for it",  form, "searchid" );
        btnSearch->setMaximumSize( btnSearch->sizeHint() );
        btnSearch->setMinimumSize( btnSearch->sizeHint() );
        topLayout->addWidget( btnSearch, 2, 1, AlignLeft );

        topLayout->activate();

        connect( btnKnowId, SIGNAL(clicked()), this, SLOT(clickIKnowID()) );
        connect( btnSearch, SIGNAL(clicked()), this, SLOT(clickSearch()) );
}

UserAddPg1::~UserAddPg1()
{
        delete btnKnowId;
        delete btnSearch;

        delete topLayout;
}

void UserAddPg1::clickIKnowID()
{
        btnKnowId->setChecked( true );
        btnSearch->setChecked( false );

        deleteOtherPages();

        QWidget *tmp = new UserAddPgKnowID( parent, "pgknowid" );
        parent->addPage( tmp, "Enter user's ID" );
        parent->setNextEnabled( tmp, false );
        parent->addPage( new UserAddPgChooseGroup( parent, "choosegroup" ), "Choose Groups" );

        parent->setNextEnabled( this, true );
}

void UserAddPg1::clickSearch()
{
        btnKnowId->setChecked( false );
        btnSearch->setChecked( true );

        deleteOtherPages();
         QWidget *tmp = new UserAddPgChooseSearchSystem( parent, "pgchoseesystem" );
        parent->addPage( tmp, "Choose system to search" );
        parent->setNextEnabled( tmp, false );
        parent->addPage( new UserAddPgSearchForm( parent, "pgsearchsystem" ), "Search" );
        parent->addPage( new UserAddPgChooseGroup( parent, "choosegroup" ), "Choose Groups" );
        parent->setNextEnabled( this, true );
}

void UserAddPg1::deleteOtherPages()
{
        while ( parent->pageCount() > 1 )
        {
                QWidget *page;
                page = parent->page( 1 );
                parent->removePage( page );
                delete page;
        }
}


/*
        ==============================================================
                                UserAddKnowID
        ==============================================================
*/
UserAddPgKnowID::UserAddPgKnowID( KWizard *parent, const char *name )
        : UserAddTemplate( parent, name )
{
        topLayout = new QGridLayout( form, 5, 4, 5, -1 );

        topLayout->setColStretch( 0, 2 );
        topLayout->setColStretch( 3, 2 );
        topLayout->setRowStretch( 0, 2 );
        topLayout->setRowStretch( 4, 2 );



        lblIMSystem = new QLabel( "IM System", form, "imsystem" );
        lblIMSystem->setMaximumHeight( lblIMSystem->sizeHint().height() );
        lblIMSystem->setMinimumSize( lblIMSystem->sizeHint() );
        topLayout->addWidget( lblIMSystem, 1, 1 );

        cboIMSystem = new QComboBox( false, form, "cboimsystem" );
        /* add in all the agents */
        cboIMSystem->insertItem( "Jabber" );
        int i;
        for( i=0; i<jabber->numberAgents(); i++ )
                cboIMSystem->insertItem( jabber->getAgent( i )->name() );
        cboIMSystem->setMaximumHeight( cboIMSystem->sizeHint().height() );
        cboIMSystem->setMinimumSize( cboIMSystem->sizeHint() );
        topLayout->addWidget( cboIMSystem, 1, 2 );

        connect( cboIMSystem, SIGNAL(activated(const QString &)), this, SLOT(changedIMSystem(const QString &)) );


        lblUserID = new QLabel( "Username/Login/ID", form, "lbllogin" );
        lblUserID->setMaximumHeight( lblUserID->sizeHint().height() );
        lblUserID->setMinimumSize( lblUserID->sizeHint() );
        topLayout->addWidget( lblUserID, 2, 1 );

        txtUserID = new QLineEdit( form, "txtlogin" );
        txtUserID->setMaximumHeight( txtUserID->sizeHint().height() );
        txtUserID->setMinimumSize( txtUserID->sizeHint() );
        topLayout->addWidget( txtUserID, 2, 2 );



        lblServer = new QLabel( "Server", form, "lblserver" );
        lblServer->setMaximumHeight( lblServer->sizeHint().height() );
        lblServer->setMinimumSize( lblServer->sizeHint() );
        topLayout->addWidget( lblServer, 3, 1 );

        txtServer = new QLineEdit( "jabber.org", form, "txtserver" );
        txtServer->setMaximumHeight( txtServer->sizeHint().height() );
        txtServer->setMinimumSize( txtServer->sizeHint() );
        topLayout->addWidget( txtServer, 3, 2 );


        topLayout->activate();

        connect( txtUserID, SIGNAL(textChanged(const QString &)), this, SLOT(checkCanProceed()) );
        connect( txtServer, SIGNAL(textChanged(const QString &)), this, SLOT(checkCanProceed()) );
}

UserAddPgKnowID::~UserAddPgKnowID()
{
        delete topLayout;

        delete cboIMSystem;
        delete lblIMSystem;
        delete txtUserID;
        delete lblUserID;
        delete txtServer;
        delete lblServer;
}

void UserAddPgKnowID::changedIMSystem( const QString &system )
{
        if ( system != "Jabber" )
        {
                txtServer->setReadOnly( true );
                txtServer->setEnabled( false );

                int i;
                for( i=0; i<jabber->numberAgents(); i++ )
                        if ( jabber->getAgent( i )->name() == system )
                                txtServer->setText( jabber->getAgent( i )->jid() );
        }
        else
        {
                txtServer->setReadOnly( false );
                txtServer->setEnabled( true );
                txtServer->setText( "jabber.org" );
        }

        checkCanProceed();
}

void UserAddPgKnowID::checkCanProceed()
{
        if (!txtUserID->text().isEmpty() && !txtServer->text().isEmpty())
        {
                parent->setNextEnabled( this, true );
        }
        else
        {
                parent->setNextEnabled( this, false );
        }

        JabberID jid( txtUserID->text(), txtServer->text(), "" );

        UserAddPgChooseGroup *page = (UserAddPgChooseGroup *)parent->page( parent->pageCount() -1 );
        page->setJabberID( jid );
}

/*
        ==============================================================
                                UserAddPgChooseGroup
        ==============================================================
*/
UserAddPgChooseGroup::UserAddPgChooseGroup( KWizard *parent, const char *name )
        : UserAddTemplate( parent, name )
{
        topLayout = new QGridLayout( form, 4, 4, 5, -1 );

        topLayout->setColStretch( 0, 2 );
        topLayout->setColStretch( 3, 2 );
        topLayout->setRowStretch( 0, 2 );
        topLayout->setRowStretch( 3, 2 );



        lblRealName = new QLabel( "Real Name", form, "lblRealName" );
        lblRealName->setMinimumSize( lblRealName->sizeHint() );
        lblRealName->setMaximumHeight( lblRealName->sizeHint().height() );
        topLayout->addWidget( lblRealName, 1, 1 );

        txtRealName = new QLineEdit( form, "txtRealName" );
        txtRealName->setMinimumSize( txtRealName->sizeHint() );
        txtRealName->setMaximumHeight( txtRealName->sizeHint().height() );
        topLayout->addWidget( txtRealName, 1, 2 );

        grpContainer = new QGroupBox( "", form, "grpContainer" );
        grpContainer->setMinimumSize( 200, 250 );
        topLayout->addMultiCellWidget( grpContainer, 2, 2, 1, 2 );

        grpLayout = new QGridLayout( grpContainer, 2, 2, 5, -1 );
        grpLayout->setColStretch( 0, 2 );
        grpLayout->setRowStretch( 0, 2 );

        groups = new QListView( grpContainer, "groups" );
        grpLayout->addMultiCellWidget( groups, 0, 0, 0, 1 );

        txtNewGroup = new QLineEdit( grpContainer, "txtNewGroup" );
        txtNewGroup->setMinimumSize( txtNewGroup->sizeHint() );
        txtNewGroup->setMaximumHeight( txtNewGroup->sizeHint().height() );
        grpLayout->addWidget( txtNewGroup, 1, 0 );

        btnAdd = new QPushButton( "&Add", grpContainer, "btnAdd" );
        btnAdd->setMinimumSize( btnAdd->sizeHint() );
        btnAdd->setMaximumSize( btnAdd->sizeHint() );
        grpLayout->addWidget( btnAdd, 1, 1 );

        grpLayout->activate();
        topLayout->activate();

        /* Populate the groups dialog */
        groups->addColumn( "Group" );
        int i;
        for ( i=0; i<jabber->numberGroups(); i++ )
                if (!jabber->getGroup( i )->getName().isEmpty())
                        (void) new QCheckListItem( groups, jabber->getGroup( i )->getName(), QCheckListItem::CheckBox );

        connect( txtRealName, SIGNAL(textChanged(const QString &)), this, SLOT(checkCanFinish()) );
        connect( groups, SIGNAL(clicked(QListViewItem *)), this, SLOT(checkCanFinish()) );

        connect( btnAdd, SIGNAL(clicked()), this, SLOT(createGroup()) );
}

UserAddPgChooseGroup::~UserAddPgChooseGroup()
{

}

void UserAddPgChooseGroup::setJabberID( JabberID jid )
{
        _jid = jid;

        txtRealName->setText( _jid.getNode() );
}

void UserAddPgChooseGroup::addThisUser()
{
        // Check to make sure that this user is not already in the system
        User *u = jabber->getUser( _jid );

        if ( u == 0 )
                u = jabber->fetchUser( _jid.getJID() );

        // Now, apply the things we gatered
        u->setRealName( txtRealName->text() );

        QCheckListItem *item = (QCheckListItem *)groups->firstChild();
        while ( item != 0 )
        {
                if (item->isOn())
                        u->addGroup( item->text() );

                item = (QCheckListItem *)item->nextSibling();
        }

        u->subscribe();
        u->commitGroups();
}

void UserAddPgChooseGroup::createGroup()
{
        if (!txtNewGroup->text().isEmpty())
        {
                QCheckListItem *item = new QCheckListItem( groups, txtNewGroup->text(), QCheckListItem::CheckBox );
                item->setOn( true );
                txtNewGroup->setText( "" );

                checkCanFinish();
        }
}

void UserAddPgChooseGroup::checkCanFinish()
{
        bool canSubmit = true;

        if (txtRealName->text().isEmpty())
                canSubmit = false;

        int count = 0;
        QCheckListItem *item = (QCheckListItem *)groups->firstChild();
        while ( item != 0 )
        {
                if (item->isOn())
                        count++;

                item = (QCheckListItem *)item->nextSibling();
        }

        if ( count == 0 )
                canSubmit = false;

        parent->setFinishEnabled( this, canSubmit );
}

/*
        ==============================================================
                        UserAddPgChooseSearchSystem
        ==============================================================
*/
UserAddPgChooseSearchSystem::UserAddPgChooseSearchSystem( KWizard *parent, const char *name )
        : UserAddTemplate( parent, name )
{
        topLayout = new QGridLayout( form, 4, 3, 5, -1 );
        topLayout->setColStretch( 0, 2 );
        topLayout->setColStretch( 2, 2 );
        topLayout->setRowStretch( 0, 2 );
        topLayout->setRowStretch( 3, 2 );

        lblIMSystem = new QLabel( "Choose IM system to search", form, "lblIMSystem" );
        lblIMSystem->setMinimumSize( lblIMSystem->sizeHint() );
        lblIMSystem->setMaximumHeight( lblIMSystem->sizeHint().height() );
        topLayout->addWidget( lblIMSystem, 1, 1 );

        cboIMSystem = new QComboBox( false, form, "cboimsystem" );
        /* add in all the agents */
        cboIMSystem->insertItem( "" );
        int i;
        for( i=0; i<jabber->numberAgents(); i++ )
                if (jabber->getAgent( i )->searchable())
                        cboIMSystem->insertItem( jabber->getAgent( i )->name() );
        cboIMSystem->setMaximumHeight( cboIMSystem->sizeHint().height() );
        cboIMSystem->setMinimumSize( cboIMSystem->sizeHint() );
        topLayout->addWidget( cboIMSystem, 2, 1 );

        connect( cboIMSystem, SIGNAL(activated(const QString &)), this, SLOT(changedIMSystem()) );

        topLayout->activate();
}

UserAddPgChooseSearchSystem::~UserAddPgChooseSearchSystem()
{

}

void UserAddPgChooseSearchSystem::changedIMSystem()
{
        if ( cboIMSystem->currentText() != "" )
        {
                int i;
                for( i=0; i<jabber->numberAgents(); i++ )
                        if ( jabber->getAgent( i )->name() == cboIMSystem->currentText() )
                                ((UserAddPgSearchForm *)parent->page( 2 ))->setService( jabber->getAgent( i )->jid() );
                parent->setNextEnabled( this, true );
         }
         else
                parent->setNextEnabled( this, false );
}

/*
        ==============================================================
                        UserAddPgSearchForm
        ==============================================================
*/
UserAddPgSearchForm::UserAddPgSearchForm( KWizard *parent, const char *name )
        : UserAddTemplate( parent, name )
{
        _status = 0;
        layout = 0;
        _btnSearch = 0;
        _instructions = 0;
        _btnSearch = 0;
        _btnNewSearch = 0;
        _results = 0;
}

UserAddPgSearchForm::~UserAddPgSearchForm()
{

}

void UserAddPgSearchForm::setService( QString service )
{
        _service = service;

        softReset();

        _status = new QLabel( "Requesting search form for " + _service, form, "lblStatus" );
        _status->resize( form->size() );
        _status->setAlignment( AlignCenter );

        /* Create the request */
        InfoQuery *request = jabber->queryManager()->createQuery();
        request->setTo( _service );
        request->setType( "get" );
        request->setNameSpace( "jabber:iq:search" );
        connect( request, SIGNAL(responceRecieved(InfoQuery *, InfoQuery *)), this, SLOT(formRecieved(InfoQuery *, InfoQuery *)) );
        request->send();

        parent->setNextEnabled( this, false );
}


void UserAddPgSearchForm::formRecieved(InfoQuery *, InfoQuery *responce)
{
        softReset();

        if ( responce->getChildNode("error", false) != 0 )
        {
                /* Humm...something went wrong getting the form from the transport */
                KMessageBox::error( this, "There was an error fetching the search form:\n\n" + responce->getChildNode("error")->getValue(), "Search Error - Konverse" );

                parent->showPage( parent->page( 1 ) );
                parent->setNextEnabled( parent->page( 1 ), false );

                return;
        }

        _instructions = new QLabel( "<p>" + responce->getChildNode("query")->getChildNode("instructions")->getValue() + "</p>", form, "instructions" );
        _key = responce->getChildNode("query")->getChildNode("key")->getValue();
        _btnSearch = new QPushButton( "&Search", form, "btnsearch" );
        connect( _btnSearch, SIGNAL(clicked()), this, SLOT( searchPushed() ) );

        /* First, create all the TextEdit boxes and lables */
        int i;
        for ( i=0; i<responce->getChildNode("query")->numberChildNodes(); i++ )
        {
                XMLNode *node = responce->getChildNode("query")->getChildNode(i);

                if ( node->getName() != "key" && node->getName() != "instructions" &&  node->getName() != "registered" )
                {
                        QLabel *tmpLabel = new QLabel( node->getName(), form, "inputfiledlabel" );
                        QLineEdit *tmpEdit;
                        if (node->getName() != "password")
                                tmpEdit= new QLineEdit( node->getValue(), form, "inputfiled" );
                        else
                                tmpEdit = (QLineEdit *)new KPasswordEdit( form, "passwordInputField" );

                        _labels.append( tmpLabel );
                        _inputBoxes.append( tmpEdit );
                }
        }

        /* Now put them in a grid layout */
        layout = new QGridLayout( form, 4 + _labels.count(), 4, 5, 5 );
        layout->setColStretch( 0, 2 );
        layout->setColStretch( 4, 2 );
        layout->setRowStretch( 0, 2 );
        layout->setRowStretch( _labels.count() + 3, 2 );

        layout->addMultiCellWidget( _instructions, 1, 1, 1, 3 ); _instructions->show();
        layout->addWidget( _btnSearch, _labels.count() + 2, 2 ); _btnSearch->show();

        for ( i=0; i<(int)_labels.count(); i++ )
        {
                layout->addWidget( _labels.at(i), i+2, 1 ); _labels.at(i)->show();
                layout->addMultiCellWidget( _inputBoxes.at(i), i+2, i+2, 2, 3 ); _inputBoxes.at(i)->show();
        }

        layout->activate();

        parent->setNextEnabled( this, false );
}


void UserAddPgSearchForm::searchPushed()
{
        /* send data */
        InfoQuery *request = jabber->queryManager()->createQuery();
        request->setTo( _service );
        request->setType("set");
        request->setNameSpace("jabber:iq:search");
        request->getChildNode("query")->getChildNode("key")->setValue( _key );

        int i;
        for ( i=0; i<(int)_labels.count(); i++ )
        {
                if ( _labels.at(i)->text() != "password" )
                        request->getChildNode("query")->getChildNode( _labels.at(i)->text() )->setValue( _inputBoxes.at(i)->text() );
                else
                        request->getChildNode("query")->getChildNode( _labels.at(i)->text() )->setValue( ((KPasswordEdit *)(_inputBoxes.at(i)))->password() );
        }
        connect( request, SIGNAL(responceRecieved(InfoQuery *, InfoQuery *)), this, SLOT(searchResults(InfoQuery *, InfoQuery *)) );
        request->send();

        softReset();

        _status = new QLabel( "Submitted search to " + _service, form, "lblStatus" );
        _status->resize( form->size() );
        _status->setAlignment( AlignCenter );
        _status->show();
}

void UserAddPgSearchForm::searchResults(InfoQuery *, InfoQuery *responce)
{
        softReset();

        if ( responce->getChildNode("error", false) != 0 )
        {
                /* Humm...something went wrong getting the form from the transport */
                KMessageBox::error( this, "There was an error while searching:\n\n" + responce->getChildNode("error")->getValue(), "Search Error - Konverse" );

                parent->showPage( parent->page( 1 ) );
                parent->setNextEnabled( parent->page( 1 ), false );

                return;
        }

        if ( responce->getChildNode("query")->numberChildNodes() == 0 )
        {
                layout = new QGridLayout( form, 4, 5, 5, 5 );
                layout->setRowStretch( 0, 2 );
                layout->setRowStretch( 3, 2 );
                layout->setColStretch( 0, 2 );
                layout->setColStretch( 4, 2 );

                _status = new QLabel( "No matches found", form, "lblstatus" );
                _status->setMinimumSize( _status->sizeHint() );
                layout->addMultiCellWidget( _status, 1, 1, 1, 3 );

                _btnNewSearch = new QPushButton( "New Search", form, "btnNewSearch" );
                connect( _btnNewSearch, SIGNAL(clicked()), this, SLOT(tryAgainPushed()) );
                layout->addWidget( _btnNewSearch, 2, 2 );

                _status->show();
                _btnNewSearch->show();
                layout->activate();

                return;
        }

        layout = new QGridLayout( form, 2, 3, 5, 5 );
        layout->setRowStretch( 0, 2 );
        layout->setColStretch( 1, 2 );

        _results = new QListView( form, "viewresults" );
        /* add the headers first */
        XMLNode *n = responce->getChildNode("query")->getChildNode( 0 );
        int i;
        for( i=0; i<n->numberChildNodes(); i++ )
                _results->addColumn( n->getChildNode(i)->getName() );
        _results->addColumn( "jabber id" );

        /* add the data */
        for( i=0; i<responce->getChildNode("query")->numberChildNodes(); i++ )
        {
                n = responce->getChildNode("query")->getChildNode( i );

                QListViewItem *newItem = new QListViewItem( _results );

                int k;
                for( k=0; k<n->numberChildNodes(); k++ )
                        newItem->setText( k, n->getChildNode( k )->getValue() );

                newItem->setText( k, n->getAttribute( "jid" ) );
        }
        layout->addMultiCellWidget( _results, 0, 0, 0, 2 );
        connect( _results, SIGNAL(clicked(QListViewItem *)), this, SLOT(itemSelected(QListViewItem *)) );

        _btnNewSearch = new QPushButton( "New Search", form, "btnNewSearch" );
        connect( _btnNewSearch, SIGNAL(clicked()), this, SLOT(tryAgainPushed()) );
        layout->addWidget( _btnNewSearch, 1, 1 );

        _results->show();
        _btnNewSearch->show();
        layout->activate();

}

void UserAddPgSearchForm::tryAgainPushed()
{
        setService( _service );
}

void UserAddPgSearchForm::itemSelected(QListViewItem *i)
{
        if (i==0)
                parent->setNextEnabled( this, false );
        else
        {
                UserAddPgChooseGroup *page = (UserAddPgChooseGroup *)parent->page( parent->pageCount() -1 );
                page->setJabberID( i->text( _results->columns() - 1 ) );

                parent->setNextEnabled( this, true );
        }
}

void UserAddPgSearchForm::softReset()
{
        if ( _status != 0 )
        {
                delete _status; _status = 0;
        }

        if ( layout != 0 )
        {
                delete layout; layout = 0;
        }

        if ( _btnSearch != 0 )
        {
                delete _btnSearch; _btnSearch = 0;
        }

        if ( _instructions != 0 )
        {
                delete _instructions; _instructions = 0;
        }

        if ( _btnSearch != 0 )
        {
                delete _btnSearch; _btnSearch = 0;
        }

        if ( _btnNewSearch != 0 )
        {
                delete _btnNewSearch; _btnNewSearch = 0;
        }

        if ( _results != 0 )
        {
                delete _results; _results = 0;
        }

        _inputBoxes.setAutoDelete( true );
        _inputBoxes.clear();
        _inputBoxes.setAutoDelete( false );

        _labels.setAutoDelete( true );
        _labels.clear();
        _labels.setAutoDelete( false );

}


