
#include <kore/version.h>
#include <kore/modulemanager.h>

#define MM_MAJOR 0
#define MM_MINOR 0
#define MM_REVISION 1
#define MM_VERSION "0.0.1"
#define MM_API_MAJOR 0
#define MM_API_MINOR 0
#define MM_API_REVISION 1
#define MM_API_VERSION "0.0.1"
#define MM_NAME "Module Manager"
#define MM_TYPE "Module Manager"
#define MM_DESCRIPTION "Default Kore Module Manager"
#define MM_SERVICE "Kore/Kernel/Module Manager"
#define MM_SERVICE_DESCRIPTION "Kore Module Manager"

using namespace kore;

ModuleManager::ModuleManager()
{
    _mmVersion = new Version(MM_MAJOR,MM_MINOR,MM_REVISION,MM_VERSION);
    _mmAPIVersion = new Version(MM_API_MAJOR,MM_API_MINOR,MM_API_REVISION,MM_API_VERSION);
    _mmInfo = new Info(this, MM_NAME, MM_TYPE, MM_DESCRIPTION, _mmVersion, _mmAPIVersion);
    setInfo(_mmInfo);
    _mmService = new Service(this, MM_SERVICE, MM_SERVICE_DESCRIPTION);
    addService(_mmService);
}
ModuleManager::~ModuleManager()
{
    unregisterModules();
    delete _mmInfo;
    delete _mmVersion;
    delete _mmAPIVersion;
    delete _mmService;
}

void ModuleManager::registerModule(Module* module)
{
    module->registeringModule(this);
    _modules.insert(module);
    module->moduleRegistered(this);
}

void ModuleManager::unregisterModule(Module* module)
{
    module->unregisteringModule(this);
    _modules.erase(_modules.find(module));
    module->moduleUnregistered(this);
}

void ModuleManager::registerModules(Module** modules)
{
    for(int i = 0; modules[i]; i++)
        registerModule(modules[i]);
}
void ModuleManager::unregisterModules()
{
    int n = _modules.size();
#ifdef WIN32
    mod_set_type::iterator* it = new mod_set_type::iterator[n];
    mod_set_type::iterator b,e;
#else
    mod_set_type::const_iterator* it = new mod_set_type::const_iterator[n];
    mod_set_type::const_iterator b,e;
#endif
    b = _modules.begin();
    e = _modules.end();
    int i = 0;
#ifdef WIN32
	mod_set_type::iterator j;
#else
	mod_set_type::const_iterator j;
#endif
    for( j = b; j != e; ++j, ++i )
        it[i] = j;
    for( i = 0; i < n; i++)
    {
        (*it[i])->unregisteringModule(this);
        Module* mod = *it[i];
        _modules.erase(it[i]);
        mod->moduleUnregistered(this);
    }
}

Module** ModuleManager::registeredModules() const
{
    int n = _modules.size();
    Module** mod = new Module*[n+1];
    mod_set_type::const_iterator b,e;
    b = _modules.begin();
    e = _modules.end();
    int i = 0;
    for( mod_set_type::const_iterator j = b; j != e; ++j, ++i )
        mod[i] = *j;
    mod[i] = 0;
    return mod;
}
