
#include <kore/version.h>
#include <kore/kernel.h>
#include <kore/servicemanager.h>

#include "koredlg_plugin.h"

#define KOREDLG_PLUGIN_MAJOR 0
#define KOREDLG_PLUGIN_MINOR 0
#define KOREDLG_PLUGIN_REVISION 1
#define KOREDLG_PLUGIN_VERSION "0.0.1"
#define KOREDLG_PLUGIN_API_MAJOR 0
#define KOREDLG_PLUGIN_API_MINOR 0
#define KOREDLG_PLUGIN_API_REVISION 2
#define KOREDLG_PLUGIN_API_VERSION "0.0.2"
#define KOREDLG_PLUGIN_NAME "KoreDialog <Qt> Plugin"
#define KOREDLG_PLUGIN_TYPE "Plugin"
#define KOREDLG_PLUGIN_DESCRIPTION "This plugin registers a ServiceProvider for '" KOREDLG_SERVICE "' which implements the KoreDialog interface. It uses Qt for displaying messages."

PLUGIN_MAIN_BODY(KoreDlgPlugin,libHandle,libName,libPath,libFlags);

KoreDlgPlugin::KoreDlgPlugin(HMODULE libhandle, const char* libname, const char* libpath, int flags):Plugin(libhandle,libname,libpath,flags)
{
    _pluginVersion = new Version(KOREDLG_PLUGIN_MAJOR,KOREDLG_PLUGIN_MINOR,KOREDLG_PLUGIN_REVISION,KOREDLG_PLUGIN_VERSION);
    _pluginAPIVersion = new Version(KOREDLG_PLUGIN_API_MAJOR,KOREDLG_PLUGIN_API_MINOR,KOREDLG_PLUGIN_API_REVISION,KOREDLG_PLUGIN_API_VERSION);
    _pluginInfo = new Info(this, KOREDLG_PLUGIN_NAME, KOREDLG_PLUGIN_TYPE, KOREDLG_PLUGIN_DESCRIPTION, _pluginVersion, _pluginAPIVersion);
    setInfo(_pluginInfo);
    dlg = 0;
}
KoreDlgPlugin::~KoreDlgPlugin()
{
    delete _pluginInfo;
    delete _pluginVersion;
    delete _pluginAPIVersion;
    delete dlg;
}
void KoreDlgPlugin::pluginLoaded()
{
    // Nothing to do here
}
void KoreDlgPlugin::initPlugin()
{
    dlg = new KoreDlg_qt();
    Kernel::instance()->serviceManager()->registerProvider( dlg );
}
void KoreDlgPlugin::unloadingPlugin()
{
    if( dlg )
    {
        Kernel::instance()->serviceManager()->unregisterProvider( dlg );
        delete dlg;
        dlg = 0;
    }
}
