#include <stdlib.h>
#include "../log.h"
#include "../ballistics.h"
#include "../terrain.h"
#include "tunnel.h"

Shellstat_bal wepTunnelInit(struct Projectilepos_bal *prjpos, void** guide,
							Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
														   void** explosioninfo), 
							void** explosioninfo)
{
	Player_pl *plhit;
    int ix, iy;
    Weapon_wep *bs;
    struct Projectilelist_bal *prj;

    prjpos->x += prjpos->vx;
    prjpos->y += prjpos->vy;
    prjpos->vy-=(bal_grav/bal_lerp_tweak);
	*guide=NULL;
	
    if(balCheckIntersect(prjpos->ox, prjpos->oy, prjpos->x, prjpos->y, &plhit, &ix, &iy))
    { /* We are in the dirt most likely so keep flying */
		
        prjpos->ox=prjpos->x;
		prjpos->oy=prjpos->y;
		return FLYING;
    }
    else
    {  /* We are in the air so launch a Large Shell */
		
	    bs=wepLookupWeapon("Large Shell");
	    prj=balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx, prjpos->vy, bs);
	    prj->stat=INITSHOT(prj);
        
        return FREEING;
    }
}

Shellstat_bal wepTunnelGuidance(void* info, struct Projectilepos_bal *prjpos, 
							   Shellstat_bal (*initexplosion)(struct Projectilepos_bal *prjpos, 
															  void** explosioninfo), 
							   void **explosioninfo)
{
    int ix, iy;
    Player_pl *plhit;
    Weapon_wep *bs;
    struct Projectilelist_bal *prj;
	Shellstat_bal res;
	
    prjpos->ox=prjpos->x;
    prjpos->oy=prjpos->y;	    
    prjpos->x+=prjpos->vx + (bal_wind/bal_lerp_tweak);
    prjpos->y+=prjpos->vy;
    prjpos->vy-=(bal_grav/bal_lerp_tweak);

    if((res=balEnvironmentAdjustProjPos(prjpos))!=FLYING)
    {
		if(plLookupPlayer(prjpos->id)) 
		{
			logPrintf(DEBUG, "Intersection at (%i, %i) of %s's shot\n", ix, iy,
					  plLookupPlayer(prjpos->id)->name);
		}
		else 
		{
			logPrintf(DEBUG, "Intersection at (%i, %i) of null's shot\n", ix, iy);
		}
		if(plhit!=NULL) logPrintf(DEBUG, "and hit %s\n", plhit->name);
		switch(res) 
		{
		case HOLDING:
			/* wtf ??? */
			break;
		case FLYING:
			prjpos->x=ix;
			prjpos->y=iy;
			/* fall through */
		case EXPLODING:
			return initexplosion(prjpos, explosioninfo);
			break;
		case FREEING:
			return FREEING;
			break;
		}
    }

    if(!(balCheckIntersect(prjpos->ox, prjpos->oy, prjpos->x, prjpos->y, &plhit, &ix, &iy)))
    {   /* We hit air so lets launch the Large shell */
        
	    bs=wepLookupWeapon("Large Shell");
	    prj=balNewShotXY(prjpos->id, 0, prjpos->x, prjpos->y, prjpos->vx, prjpos->vy, bs);
	    prj->stat=INITSHOT(prj);
        
        return FREEING;      
    }

    return FLYING;
}
