
#include <qapplication.h>
#include <qtranslator.h>
#include <qtextcodec.h>
#include "kcallwidget.h"
#include "kphone.h"
#include "kphoneview.h"
#include "siputil.h"

int main( int argc, char **argv )
{
	int listenport = 5060;
	QString port = "";
	QString user = "";
	QString autodial = "";
	QString autodtmf = "";
	bool looseRoute = false;
	bool strictRoute = false;

	QApplication a( argc, argv );

	// translation file for application strings
	QTranslator myapp( 0 );
	myapp.load( QString( "kphone_" ) + QTextCodec::locale(), PO_DIR );
	a.installTranslator( &myapp );
	
	for ( int i = 0; i < a.argc(); i++ ) {
		if( QString( a.argv()[i] ) == "-u" ) {
			if( i+1 < a.argc() ) {
				user = QString( a.argv()[++i] );
			}
		} else if( QString( a.argv()[i] ) == "-p" ) {
			if( i+1 < a.argc() ) {
				port = QString( a.argv()[++i] );
			}
			listenport = port.toInt();
		} else if( QString( a.argv()[i] ) == "-l" ) {
			looseRoute = true;
		} else if( QString( a.argv()[i] ) == "-s" ) {
			strictRoute = true;
		} else if( QString( a.argv()[i] ) == "-d") {
			/* Dial... */
			if( i+1 < a.argc() )
				autodial = QString( a.argv()[++i] );
#ifndef NO_DTMFSENDER
		} else if( QString( a.argv()[i] ) == "-D") {
			/* DTMF... */		
			if( i+1 < a.argc() )
				autodtmf = QString( a.argv()[++i] );
#endif
		} else if( QString( a.argv()[i] ) == "-F") {
			/* Pre-set FQDN */
			if( i+1 < a.argc() )
				SipUtil::setLocalFqdn(QString( a.argv()[++i] ));
		}
	}
	KPhone *phone = new KPhone( listenport, user, looseRoute, strictRoute );
	a.setMainWidget( phone );
	phone->show();
	if (autodial != "") {
		KCallWidget *autocw = phone->getView()->DoCall(autodial, SipCall::videoCall);
#ifndef NO_DTMFSENDER
		if (autodtmf != "") {
			autocw->setDTMFSender(autodtmf);
		}
#endif
	}
	return a.exec();
}
