/***************************************************************************
                          logcore.cpp  -  description
                             -------------------
    begin                : Wed Feb 7 2001
    copyright            : (C) 2001 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "logcore.h"

#include <stdlib.h>
#include <stdio.h>
#include <time.h>

logCore::logCore()
{

	/* Open the dxcc.db database for reading (prefix lookup)
     Check if dxcc db exists, we may not have it */
  if (locate ("appdata", "dxcc.db") != NULL){
  char *dxccfile = strdup (locate ("appdata", "dxcc.db"));
  db_create(&dxccdb, NULL, 0);
	dxccdb->open(dxccdb, dxccfile, NULL, DB_BTREE, DB_RDONLY, 0664);
  }
	/* And the QSO Logbook... */

	char *logfile = strdup (locateLocal ("appdata", "log.db"));
	db_create(&calldb, NULL, 0);
	calldb->set_flags(calldb, DB_DUP);
	calldb->open(calldb, logfile, NULL, DB_BTREE, DB_CREATE, 0664);
}
logCore::~logCore()
{
	/* close the 2 databases, only if dxcc exists, logbook checked in main.cpp */
	
  if (locate ("appdata", "dxcc.db") != NULL){
  dxccdb->close(dxccdb, 0);
  }
	calldb->close(calldb, 0);
}

s_dxcc logCore::getDxcc (QString _call) {
	s_dxcc _dxcc;	
	char _str[20];
	DBT data,key;
	int i,j;
	char* call = strdup (_call.latin1());

	memset(&key, 0, sizeof(DBT));
	memset(&data, 0, sizeof(DBT));

	key.size = strlen(call);
	key.data = call;

	data.flags = DB_DBT_MALLOC;

	/* search for the right record in the dxcc database */

	for (i=strlen(call);i!=0;i--) {
		if (dxccdb->get(dxccdb, NULL, &key, &data, 0)) {
			key.size--;
			call[key.size]=0;
			free(data.data);
		}
		else
			break;
	}

	if (i==0) { // no prefix found!
		_dxcc.country[0]=0;
		_dxcc.cq=-1;
		_dxcc.itu=-1;
		_dxcc.longitude=0.0;
		_dxcc.latitude=0.0;
		_dxcc.timezone=0.0;
		_dxcc.prefix[0]=0;
		return _dxcc;
	}


	char* logstr;
	logstr = (char*)data.data;

	/* process the logstr string and fill the dxcc structure */
	i=0;j=0;
	while (logstr[i] != 1) {
		_dxcc.country[j]=logstr[i];
    ++i;++j;
	}
	_dxcc.country[j]=0;
	j=0;i++;
	while (logstr[i] != 1) {
		_str[j]=logstr[i];
    ++i;++j;
	}
	_str[j]=0;
	_dxcc.cq = atoi(_str);	
	j=0;i++;
	while (logstr[i] != 1) {
		_str[j]=logstr[i];
    ++i;++j;
	}
	_str[j]=0;
	_dxcc.itu = atoi(_str);	
	j=0;i++;
	while (logstr[i] != 1) {
		_dxcc.continent[j]=logstr[i];
    ++i;++j;
	}
	_dxcc.continent[j]=0;
	j=0;i++;
	while (logstr[i] != 1) {
		_str[j]=logstr[i];
    ++i;++j;
	}
	_str[j]=0;
	_dxcc.longitude=atof(_str);
	j=0;i++;
	while (logstr[i] != 1) {
		_str[j]=logstr[i];
    ++i;++j;
	}
	_str[j]=0;
	_dxcc.latitude=atof(_str);
	j=0;i++;
	while ((unsigned int)i <= data.size) {
		_str[j]=logstr[i];
    ++i;++j;
	}
	_str[j]=0;
	_dxcc.timezone=atof(_str);
	j=0;i++;

	/* Set the prefix - simply copy the string 'call' now contains */

	strcpy(_dxcc.prefix, call);

  free(call);
	return _dxcc;
}

void logCore::appendQSO (QString _call, QString _name, QString _qth, QString _rstr, QString _rsts, QString _band, QString _notes, time_t _t) {
	DBT key,data;

	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));

	/* Build the data string */
	
	if (_t==0) _t=time(NULL);
	QString str = _name+"\001"+_qth+"\001"+_rstr+"\001"+_rsts+"\001"+_band+"\001"+_notes+"\001"+QString::number(_t);

	data.data=(char*)str.latin1();
  data.size=str.length();

	key.data = (char*)_call.latin1();
  key.size = _call.length();

	calldb->put (calldb, NULL, &key, &data, 0);
}

/* Searches the next call, beginning with record _recno. Returns true if found */

QSortedList<qso> logCore::searchCall (QString _call) {
	int i;
	QSortedList<qso> list;
	DBT key,data;
	DBC *cursor;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	calldb->cursor(calldb, NULL, &cursor, 0);
	/* Build the key */

	key.data = (char*)_call.latin1();
	key.size = _call.length();

	data.flags = DB_DBT_MALLOC;

	i = cursor->c_get(cursor, &key, &data, DB_SET);
	if (i)
		return list;
  else {
		list.append(getQSO(&data,&key));
		free(data.data);
  }

	for (;;) {
		i = cursor->c_get(cursor, &key, &data, DB_NEXT_DUP);
		if(i)
			break;
		else {
			list.append(getQSO(&data,&key));
			free(data.data);
			}
	}

	cursor->c_close(cursor);
	list.sort();
	return list;
}

qso* logCore::getQSO (DBT* data, DBT* key) {
	qso* _qso = new qso();
	char* charpt;
	char buffer[2048];
	int i,j;

	charpt = (char*)key->data;
	for (i=0;(unsigned int)i<=key->size;++i)
		buffer[i]=charpt[i];
	buffer[i-1]=0;
	_qso->call(buffer);

	charpt = (char*)data->data;
	i=0;j=0;

	while (charpt[i] != 1) {
		buffer[j]=charpt[i];
    ++i;++j;
	}
	buffer[j]=0;
	_qso->name(buffer);
	j=0;i++;
	while (charpt[i] != 1) {
		buffer[j]=charpt[i];
    ++i;++j;
	}
	buffer[j]=0;
	_qso->qth(buffer);
	j=0;i++;
	while (charpt[i] != 1) {
		buffer[j]=charpt[i];
    ++i;++j;
	}
	buffer[j]=0;
	_qso->rstr(buffer);
	j=0;i++;
	while (charpt[i] != 1) {
		buffer[j]=charpt[i];
    ++i;++j;
	}
	buffer[j]=0;
	_qso->rsts(buffer);
	j=0;i++;
	while (charpt[i] != 1) {
		buffer[j]=charpt[i];
    ++i;++j;
	}
	buffer[j]=0;
	_qso->band(buffer);
	j=0;i++;
	while (charpt[i] != 1) {
		buffer[j]=charpt[i];
    ++i;++j;
	}
	buffer[j]=0;
	_qso->notes(buffer);
	j=0;i++;
	while ((unsigned int)i <= data->size) {
		buffer[j]=charpt[i];
    ++i;++j;
	}
	buffer[j-1]=0;
	_qso->time(atol(buffer));
	
	return _qso;
}

QSortedList<qso> logCore::searchString (QString _str)
{
	QSortedList<qso> list;
	qso* q;
	DBT key,data;
	DBC *cursor;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	calldb->cursor(calldb, NULL, &cursor, 0);

	data.flags = DB_DBT_MALLOC;
	key.flags = DB_DBT_MALLOC;

	QString str=_str.lower();

	while (cursor->c_get(cursor, &key, &data, DB_NEXT) != DB_NOTFOUND) {
		q = getQSO (&data,&key);
		free (data.data);
		free (key.data);

		if (q->call().lower().contains(str) || q->name().lower().contains(str) ||
				q->qth().lower().contains(str)  || q->band().lower().contains(str) ||
				q->notes().lower().contains(str)) {
					list.append(q);
				}
				else
					delete q;
    }
	cursor->c_close(cursor);
	list.sort();
	return list;
}

/* remove a qso from the logbook. the QSO is referenced by its time */

void logCore::removeQSO (time_t t)
{
	/* walk throuw all records */
	qso* q;
	DBT key,data;
	DBC *cursor;
	memset(&key, 0, sizeof(key));
	memset(&data, 0, sizeof(data));
	calldb->cursor(calldb, NULL, &cursor, 0);

	data.flags = DB_DBT_MALLOC;
	key.flags = DB_DBT_MALLOC;

	while (cursor->c_get(cursor, &key, &data, DB_NEXT) != DB_NOTFOUND) {
		q = getQSO (&data,&key);
		if (q->time() == t)
			cursor->c_del(cursor,0);
		free(key.data);
		free(data.data);
    }
	cursor->c_close(cursor);
}
