// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "AudioConversion.h"
#include "AudioConverter.h"
#include "AudioFileInfo.h"

#include <kapp.h>
#include <klocale.h>
#include <kprocess.h>

#include <qmessagebox.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>

AudioConversion::AudioConversion(AudioFileInfo *afil,AudioConverter *acon) {
  myAudio=afil;
  myConverter=acon;
  acon->setAudioConversion(this);
}

AudioConversion::AudioConversion(AudioFileInfo *afil,AudioConverter *acon,
                 int (*fx)(int argc,char **argv)):ProcessInterface(fx) {
  myAudio=afil;
  myConverter=acon;
  acon->setAudioConversion(this);
}


bool AudioConversion::convertAudio(const char *filename) {

  prepareProcess();
  strcpy(convertFilename,filename);

  myConverter->startTrack(myAudio->dataSize());
  if (!myConverter->doConvert(myAudio->getSourceName(),convertFilename)) {
    closeProcess();
    return(false);
  }

  reportAction(i18n("Decoding complex audio format..."));
 
  

  startProcess();
  return(true);
}

int AudioConversion::processCleanup(int retval) {
  int padbytes,fdes;
  struct stat astat;
  if (retval!=1) {
    remove(convertFilename);
  }
  if (retval==-2) {
    QMessageBox::critical(0,QString::null,i18n("Unable to read audio complex format!"));
  }

  closeProcess();
  if (retval!=1) return(0);
 
  if (stat(convertFilename,&astat)!=0) {
    remove(convertFilename);
    return(0);
  }

  if (!S_ISFIFO(astat.st_mode)) {

    padbytes=2352-(astat.st_size%2352);
    if (padbytes==2352) {
      padbytes=0;
    }

    if (padbytes!=0) {
      char padchar;
      fdes=open(convertFilename,O_WRONLY|O_APPEND,0644);
      if (fdes==-1) {
        remove(convertFilename);
        return (0);
      }
      padchar=0;
      while (padbytes-->0) {
        if (write(fdes,&padchar,1)!=1) {
   	  close (fdes);  
          remove(convertFilename);
	  return(0);
        }
      }
      close(fdes);
    }
  }
  return(1);
}

int AudioConversion::processExited(void) {
  return(myConverter->processExited());
}

bool AudioConversion::processStderrLine(char *linebuffer) {
  return(myConverter->processStderrLine(linebuffer));
}

bool AudioConversion::processStdoutLine(char *linebuffer) {
  return(myConverter->processStdoutLine(linebuffer));
}

void AudioConversion::setProgress(long int val,long int max) {
  reportProgress(val,max);
}
