// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "AudioConverter.h"
#include "AudioConversion.h"

#include <stdlib.h>
#include <string.h>

AudioConverter::AudioConverter(void) {
  refCount=0;
}

void AudioConverter::setAudioConversion(AudioConversion *acon) {
  audioConversion=acon;
  convflag=0;
  trackSize=999999;
}

void AudioConverter::startTrack(long int size) {
  trackSize=size;
  audioConversion->setProgress(0,trackSize);
}

void AudioConverter::setPosition(long int pos) {
  audioConversion->setProgress(pos,trackSize);
}

bool AudioConverter::doConvert(const char *,const char *) {
  return(false);
}

int AudioConverter::processExited(void) {
  return(convflag?1:-2);
}

AudioConverter &AudioConverter::operator<<(const char *str) {
  *audioConversion<<str;
  return(*this);  
}

bool AudioConverter::processStderrLine(char *) {
  return(true);
}

bool AudioConverter::processStdoutLine(char *) {
  return(true);
}

bool AudioConverter::strCompare(const char *s1,const char *s2,int len) {
  return(strncmp(s1,s2,len));
}

long int AudioConverter::strToLong(const char *src,char **endptr,int base) {
  return(strtol(src,endptr,base));
}
