// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "AudioFileConvert.h"
#include "AudioFileInfo.h"
#include "AudioFileOp.h"
#include "AudioDevice.h"

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/stat.h>
#include <sys/ioctl.h>

#include <qtimer.h>
#include <qobject.h>

#include "AudioFileConvert.moc"


AudioFileConvert::AudioFileConvert(AudioFileInfo *afil) {
  audioInfo=afil;
  fileOp=new AudioFileOp(afil);
}


AudioFileConvert::AudioFileConvert(AudioFileInfo *afil,
				   int (*fx)(ProcessInterface *afi,const char *fn),
				   const char *fnx):
  ProcessInterface(fx,fnx) {
  audioInfo=afil;
  fileOp=new AudioFileOp(afil);
}

AudioFileConvert::~AudioFileConvert(void) {
  if (fileOp!=0) delete fileOp;
}


int AudioFileConvert::buildImageFork(const char *fn,int playmode,const char *sfn) {
  int channel;
  long int samplesleft,maxsamples;
  float pos2;
  long int sample1[2],sample2[2];
  long int sampleswritten=0;
  float boost[2];
  long int start,end;

  if (audioInfo->balance()>0) {
    boost[0]=audioInfo->boost()*(1-audioInfo->balance());
  } else {
    boost[0]=audioInfo->boost();
  }

  if (audioInfo->balance()<0) {
    boost[1]=audioInfo->boost()*(1+audioInfo->balance());
  } else {
    boost[1]=audioInfo->boost();
  }

  if (!fileOp->openWrite(fn)) {
    return(0);
  }

  start=audioInfo->startPos();
  end=audioInfo->endPos();

  if (playmode) {
    if (fcntl(STDIN_FILENO,F_SETFL,O_NONBLOCK)==-1) {
      fileOp->closeWrite();
      return(0);
    }
    if (AudioDevice::setupDevice(fileOp->getTargetDescriptor())==false) {
      fileOp->closeWrite();
      return(0);
    }
    fileOp->setSwapping(false);
    if (startAudio!=-1) {
      start=startAudio*588;
      if (start>=end) {
        end=audioInfo->dataSamples()-1;
      }
    }
    fprintf(stdout,"#PROGRESS# %ld\n",(start)/588);
    fflush(stdout);

  }


  if (!fileOp->openRead(sfn==0?audioInfo->getBurnFile():sfn)) 
   {
    fileOp->closeWrite();
    remove(fn);
    return(0);
  }
  if (!fileOp->positionSample(start)) {
    fileOp->closeRead();
    fileOp->closeWrite();
    remove(fn);
    return(0);
  }
  samplesleft= (end+1)-start;
  maxsamples=samplesleft;

  if (!fileOp->readSample(&sample1[0])) {
    fileOp->closeRead();
    fileOp->closeWrite();
    remove(fn);
    return(0);
  }
  if (audioInfo->channels()>1) {

    if (!fileOp->readSample(&sample1[1])) {
      fileOp->closeRead();
      fileOp->closeWrite();
      remove(fn);
      return(0);
    }
  } else {
    sample1[1]=sample1[0];
  }


  for (channel=2;channel<audioInfo->channels();++channel) {
    long int dummy;
    if (!fileOp->readSample(&dummy)) {
      fileOp->closeRead();
      fileOp->closeWrite();
      remove(fn);
      return(0);
    }
  }
  samplesleft--;
  pos2=0;
  sample2[0]=sample1[0];
  sample2[1]=sample1[1];

  for (channel=0;channel<2;++channel) {
    if (!fileOp->writeCDDASample(sample1[channel])) {
      fileOp->closeRead();
      fileOp->closeWrite();
      remove(fn);
      return(0);
    }
  }
  ++sampleswritten;

  while ( (samplesleft>0) || (pos2>=1) ) {
    int xchannel;

    if (pos2>=1) {
      for (channel=0;channel<2;++channel) {
        if (audioInfo->rate()!=44100) {
          sample1[channel]= (long int) (sample1[channel]+
					( (float) (sample2[channel]-sample1[channel]) *
					  ((float) 1)/ pos2 ));
	} else {
          sample1[channel]=sample2[channel];
	}

        if (!fileOp->writeCDDASample((float)sample1[channel]*boost[channel])) {
          fileOp->closeRead();
          fileOp->closeWrite();
          remove(fn);
          return(0);
	}
      }
      sampleswritten++;
      pos2-=1;
      continue;
    }
    if (!fileOp->readSample(&sample2[0])) {
      fileOp->closeRead();
      fileOp->closeWrite();
      remove(fn);
      return(0);
    }
    if (audioInfo->channels()>1) {

      if (!fileOp->readSample(&sample2[1])) {
        fileOp->closeRead();
        fileOp->closeWrite();
        remove(fn);
        return(0);
      }
    } else {
      sample2[1]=sample2[0];
    }


    for (xchannel=2;xchannel<audioInfo->channels();++xchannel) {
      long int dummy;
      if (!fileOp->readSample(&dummy)) {
        fileOp->closeRead();
        fileOp->closeWrite();
        remove(fn);
        return(0);
      }
    }
    samplesleft--;
    if ((samplesleft%1000)==0) {
      if (!playmode)
	{
	  fprintf(stdout,"#PROGRESS# %ld %ld\n",(maxsamples-samplesleft)/1000,(maxsamples+999)/1000);
	} else {
	  char inbuf[80];
	  while ( fgets(inbuf,80,stdin)!=0) {
	    if (strncmp(inbuf,"#BOOST#",7)==0) {
	      float boo;
              sscanf(inbuf+8,"%f",&boo);
              audioInfo->setBoost(boo);

	      if (audioInfo->balance()>0) {
	        boost[0]=audioInfo->boost()*(1-audioInfo->balance());
	      } else {
	        boost[0]=audioInfo->boost();
	      }

	      if (audioInfo->balance()<0) {
	        boost[1]=audioInfo->boost()*(1+audioInfo->balance());
	      } else {
	        boost[1]=audioInfo->boost();
	      }
	    }


	    if (strncmp(inbuf,"#BALANCE#",9)==0) {
              float bal;
	      sscanf(inbuf+10,"%f",&bal);
              audioInfo->setBalance(bal);

	      if (audioInfo->balance()>0) {
	        boost[0]=audioInfo->boost()*(1-audioInfo->balance());
	      } else {
	        boost[0]=audioInfo->boost();
	      }

	      if (audioInfo->balance()<0) {
	        boost[1]=audioInfo->boost()*(1+audioInfo->balance());
	      } else {
	        boost[1]=audioInfo->boost();
	      }

	    }



	    if (strncmp(inbuf,"#SET#",5)==0) {
	      unsigned long newpos,xend;
	      xend=audioInfo->endPos();
	      newpos=strtoul(inbuf+5,0,10);
	      newpos*=588;
	      if ((signed long) newpos>=audioInfo->endPos()) xend=audioInfo->dataSamples()-1;
	      samplesleft= (xend+1)-newpos;
	      maxsamples=samplesleft;
	      if (!fileOp->positionSample(newpos)) {
		fileOp->closeRead();
		fileOp->closeWrite();
		remove(fn);
		return(0);
              }
              AudioDevice::syncDevice(fileOp->getTargetDescriptor());
	      fprintf(stdout,"#PROGRESS# %ld\n",newpos/588);
	      fflush(stdout);
	    }
	  }
	}
    }
    pos2+= (float) 44100/ (float) audioInfo->rate();
  }

  samplesleft=0;
  if (sampleswritten%588!=0) {
    samplesleft=588-(sampleswritten%588);
  }

  if ( (!playmode) && (sampleswritten<(44100*4))) {
    samplesleft=(44100*4)-sampleswritten;
  }
  samplesleft*=2;
  while (samplesleft) {
    --samplesleft;
    if (!fileOp->writeCDDASample(0)) {
      fileOp->closeRead();
      fileOp->closeWrite();
      remove(fn);
      return(0);
    }
  }

  if (!fileOp->flushCDDABuffer()) {
    fileOp->closeRead();
    fileOp->closeWrite();
    remove(fn);
    return(0);
  }
  if (playmode) {
    AudioDevice::syncDevice(fileOp->getTargetDescriptor());
  }

  printf("#DONE#\n");
  fflush(stdout);
  while (true) {
    char inbuf[80];
    bool killfound=false;
    while ( fgets(inbuf,80,stdin)!=0) {
      if (strncmp(inbuf,"#KILL#",6)==0) {
        killfound=true;
        break;
      }
    }
    if (killfound==true) break;
  }
  fileOp->closeRead();
  fileOp->closeWrite();
  return(1);
}
