// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     


#ifndef AUDIOIDENTIFY_INCLUDED
#define AUDIOIDENTIFY_INCLUDED

class AudioFileOp;
class AudioFileInfo;

class AudioIdentify {

 public:

  /** 
      <pre>
      Byte endian enum
      Endian_Little : the file is in litte endian format
      Endian_Big : the file is in big endian format
      </pre>
  */
  enum Sample_Endian{Endian_Little,Endian_Big};

  /**
     <pre>
     Sample type enum
     Samples_PCM : samples are in PCM format
     </pre>
  */
  enum Sample_Format{Samples_PCM,Samples_PCM_Unsigned,Samples_ALaw,Samples_ULaw};

  /**
     <pre>
     Sample size enum
     Samples_8Bit : sample size is 8 bit
     Samples_16Bit : sample size is 16 bit
     Samples_24Bit : sample size is 24 bit
     Samples_32Bit : sample size is 32 bit
     </pre>
  */
  enum Sample_Size{Samples_8Bit,Samples_16Bit,Samples_24Bit,Samples_32Bit};

  int identifyFormat(AudioFileOp *aform);
	  
 protected:
  virtual int identify(void);

  int  readLEShort (long int  *mshort,int words=1);
  int  readLELong  (long int  *mlong,int words=1);
  int  readBEShort (long int  *mshort,int words=1);
  int  readBELong  (long int  *mlong,int words=1);
  int  readChar    (long int  *mchar,int words=1);
  int  readCharUS  (long int  *mchar,int words=1);
  int  readShort   (long int  *mshort,int words=1);
  int  readLong    (long int  *mlong,int words=1);
  int  skipRead    (int        bytes);
  int  backRead    (int        bytes);
  void resetFile   (void);
  int  readString  (char *mstring,int length);
  long getPosition (void);
  
  void setSampleFormat(AudioIdentify::Sample_Format format);
  void setSampleSize(AudioIdentify::Sample_Size siz);
  void setSampleEndian(AudioIdentify::Sample_Endian endian);
  void setSampleChannels(int chan);
  void setSampleRate(int rate);
  void setDataPos(long pos);
  void setDataSize(long siz);
  void setName(const char *name);
  void setConverter(class AudioConverter *acon,int (*fx)(int argc,char **argv)=0);
  
  AudioIdentify::Sample_Format sampleFormat(void);
  AudioIdentify::Sample_Size sampleSize(void);
  AudioIdentify::Sample_Endian  sampleEndian(void);
  int sampleChannels(void);
  int sampleRate(void);
  long dataPos(void);
  long dataSize(void);

  int getFileDescriptor(void);

  long int strToLong(const char *src,char **endptr,int base);
  bool strCompare(const char *s1,const char *s2,int len);

  private:
    AudioFileOp *fileFormat;
    AudioFileInfo *audio ();
};

#endif
