// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef AUDIOSCANIMAGE_INCLUDED
#define AUDIOSCANIMAGE_INCLUDED

#include "ProcessInterface.h"
#include <qobject.h>

class AudioFileInfo;
class AudioFileOp;

class AudioScanImage : public ProcessInterface {
  Q_OBJECT

    public:
  AudioScanImage(AudioFileInfo *afil);
  ~AudioScanImage(void);
  float    maximumBoost(const char *fn);
  int                  scanImage(void);

 private:
  static int scanImageHFork(ProcessInterface *afi,const char *fn);

 protected:
  virtual int  processCleanup(int rval); 
  virtual int processExited(void);
  virtual bool processStdoutLine(char *buf);

  AudioFileOp *fileOp;
  AudioFileInfo *audioInfo;
  int ImagizeFlag;
};
#endif
