// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef _AUDIO_WAVE_DATA_H_
#define _AUDIO_WAVE_DATA_H_

#include "WaveData.h"

class AudioFileInfo;
class AudioFileOp;

#define AUDIOWAVEDATA_MAXCHAN 8

class AudioWaveData : public WaveData
{
	public:
	  AudioWaveData(AudioFileInfo *afi);
          virtual ~AudioWaveData(void);
          
          virtual long getData(int curve,long int x);
          virtual int getCurves(void);
          virtual long getMaxX(void);
          virtual long getMinY(void);
          virtual long getMaxY(void);
          virtual long getSampleRate(void);
                             
        private:
          void fillCache(long int sample);
 
          AudioFileInfo *myAudio;
          AudioFileOp *myOp;
          
          long int samplePos;
          long int memorySample;
          long int sampleCache[AUDIOWAVEDATA_MAXCHAN];
          bool validFile;
};

#endif
