// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "ChooseDialog.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qradiobutton.h>

#include <kapp.h>
#include <klocale.h>
#include "ChooseDialog.moc"

ChooseDialog:: ChooseDialog(const char *caption,const char *headertext,
			    QWidget *parent, const char *name)
  :QDialog(parent,name,true) {
  QVBoxLayout *mainlay;
  QButton *okbut;
  mainlay=new QVBoxLayout(this);

  headingText=new QLabel(this);
  mainlay->addWidget(headingText,1);
  if (headertext!=0) headingText->setText(headertext);
  if (caption!=0) setCaption(caption);

  headingText->setFixedSize(headingText->sizeHint());

  mainlay->addStretch(1);
  buttonGroup=new QButtonGroup(i18n("Please choose:"),this);
  mainlay->addWidget(buttonGroup,4);
  mainlay->addStretch(1);

  buttonGroup->setAlignment(AlignHCenter);
  buttonGroup->setMinimumSize(300,60);
  buttonLayout=new QVBoxLayout(buttonGroup,20,0);


  okbut=new QPushButton(i18n("OK"),this);
  okbut->setMinimumSize(okbut->sizeHint());
  mainlay->addWidget(okbut,0);

  mainlay->addStretch(1);
  mainlay->activate();
  buttonLayout->activate();


  connect(buttonGroup,SIGNAL(clicked(int)),this,SLOT(newSelected(int)));
  connect(okbut,SIGNAL(clicked()),this,SLOT(okButton()));

  selectedButton=0;
  buttonHeight=60;
  doCheck=true;
}

ChooseDialog:: ~ChooseDialog(void) {

}


void ChooseDialog::addButton(const char *buttontext) {
  QRadioButton *radio;

  radio=new QRadioButton(buttontext,buttonGroup);
  radio->setFixedSize(radio->sizeHint());
  buttonLayout->addWidget(radio,1);
  buttonLayout->addStretch(2);
  if (doCheck) {
    doCheck=false;
    radio->setChecked(true);
  }
  buttonHeight+=20;
  buttonGroup->setMinimumHeight(buttonHeight);
}

void ChooseDialog::newSelected(int selected) {
  selectedButton=selected;
}

void ChooseDialog::okButton(void) {
  done(selectedButton);
}
