// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef PROGRESSDIALOG_INCLUDED
#define PROGRESSDIALOG_INCLUDED

#include <qwidget.h>
#include <qlistview.h>

class ProcessInterface;

class ProgressDialog : public QWidget {
  Q_OBJECT;

 public:

  enum ProgressType {Progress_None,Progress_Single,Progress_Double,Progress_Triple};

  ProgressDialog( QWidget *parent=0, const char *name=0, 
		  QString workingtext=QString::null,
		  enum ProgressType ptyp=Progress_Single,bool modal=true);
  ~ProgressDialog(void);
  void addStatusView(void);
  void attachProcess(ProcessInterface *proc);
  int  exec(void);

  public slots:
    void setWorkText(QString wt);
  void abortDialog(int returncode=-1);
  void abortCancel(void);
  void setProgress(long int val,long int maxval);
  void setSecondProgress(long int val,long int maxval);
  void setThirdProgress(long int val,long int maxval);
  void setProtectedProgress(long int val,long int maxval);
  void setSecondProtectedProgress(long int val,long int maxval);
  void setThirdProtectedProgress(long int val,long int maxval);
  void done(int result);
  void detachProcess(ProcessInterface *proc);
  void printStatusLine(QString line);
  void setProgressDescription(QString descr,int prognum=1);
  void setBuffer(int percent);
  void setupSecondProgress(long int total,long int offset);
  void clearSecondProgress(void);
  void advancedView(void);
  
  protected:
  virtual void closeEvent(QCloseEvent *clev);
  void updateSecondProgress(long int firstval);

  protected slots:
    void cancelPressed(void);
    void processTerminated(ProcessInterface *proc,int rv);

 signals:
  void canceled(void);

 private:
  class KProgress *pwidget;
  class KProgress *pwidget2;
  class KProgress *pwidget3;
  class QPushButton *pcancel;
  class QVBoxLayout *pvlayout;
  class QLabel *pwork;
  class QLabel *plabel1;
  class QLabel *plabel2;
  class QLabel *plabel3;
  class KEdit *edit;
  class QPushButton *advanced;

  long int oldval,oldmax;
  long int oldval2,oldmax2;
  long int oldval3,oldmax3;
  char progresstext[2048];
  char worktext[1024];

  int  progressResult;
  bool wasShown;
  bool isModal;

  long int secondTotal;
  long int secondOffset;

  class ProcessInterface *attachedProcess;
};

#endif
