// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef _PROJECT_CLASSIC_WIDGET_
#define _PROJECT_CLASSIC_WIDGET_

#include <qwidget.h>
#include "TrackListManager.h"
#include "TrackListView.h"
#include <qlabel.h>
#include <qpushbutton.h>

#define TRACK_COLUMNS 4

class ProjectClassicWidget : public QWidget {
  Q_OBJECT;
 public:
  ProjectClassicWidget(QWidget *parent, TrackListManager *TLM);
 protected:
  virtual void resizeEvent(QResizeEvent *rs);
 private:
  TrackListView *TLV;
  class QPushButton   *MWAddTrack;
  class QPushButton   *MWEditTrack;
  class QPushButton   *MWDeleteTrack;
  class QPushButton   *MWTrackUp;
  class QPushButton   *MWTrackUpdate;
  class QPushButton   *MWTrackDown;
  
  class QLabel        *SumLabel; 
  
  void readColWidth(int xsiz=-1);
  void writeColWidth(void);
  float Colwidth[TRACK_COLUMNS];

  bool firstInvoke;
  public slots:
    void  updateTrackSum(int trackCount, QString duration);
};

#endif
