// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Joseph Wenninger <jowenn@bigfoot.com>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef _TrackListView_
#define _TrackListView_

#include <klistview.h>
#include <TrackListManager.h>
#include <qdragobject.h>

class TrackListView: public KListView {
  Q_OBJECT;
 public:
  TrackListView(QWidget *parent, const char *name,TrackListManager *tracklistmanager, bool ClassicStyle=true);
  int getCurrentId();
 private:
  bool isClassic;
  TrackListManager *TLM;
  QListViewItem *findTrack(int id);
  int itemToChange;
  int itemNewPos;
  bool changeDirection;
  int listEntriesCnt;
  bool selectionChanged;
  protected slots:
    void editTrack();
  bool acceptDrag(QDropEvent *e) const;
  void changeNow();
  void changeNowFar();
  void Moved(QListViewItem *item, QListViewItem *afterFirst, QListViewItem *afterNow);
  void Dropped(QDropEvent *e,QListViewItem *after);
  void selectionChangedInternal();
  void executedInternal();
  public slots:
    void moveUp();
  void moveDown();
  void needUpdate(int trackId);
  void changeCurrent(int trackId);
  void appendTrack();
  void deleteTrack();
  void trackDeleted();
  void clearTracks();
  void updateTrack();
 signals:
  void moveByOne(int itemId, bool up);
  void selectionChangedDelayed();
};

#endif
