// KreateCD - CD recording software for the K desktop environment
//
// 2001 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "VorbisConverter.h"

#include <vorbis/vorbisfile.h>
#include <vorbis/codec.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

#define BUFFER_SIZE 32*1024

bool VorbisConverter::doConvert(const char *source,const char *dest) {
  *this<<"vorbisdec"<<source<<dest;
  firstCall=true;
  return(true);
}

bool VorbisConverter::processStderrLine(char *linebuffer) {
  if (strCompare("#POS#",linebuffer,5)==0) {
    long int pos;
    char *xptr,*yptr;
    xptr=linebuffer+5;
    if (*xptr=='\0') return(true);
    pos=strToLong(xptr,&yptr,10);
    if (yptr==xptr) return(true);
    setPosition(pos);
  }
 
  if (strCompare(linebuffer,"#OK#",4)==0) convflag=1;
  return(true);
}

int VorbisConverter::vorbisDecoder(int argc,char **argv) {
  OggVorbis_File vf;
  FILE *instream;
  int outfd;
  char *convbuffer;
  int current_section = -1, eof = 0, ret;
  long int position=0,last_position=0;

  if (argc!=3) {
    fprintf(stderr,"#ERROR# Param\n");
    return(1);
  }

  if ((instream = fopen(argv[1], "rb")) == NULL) {
    fprintf(stderr, "#ERROR# Infile\n");
    return(1);
  }

  outfd=open(argv[2],O_WRONLY|O_CREAT,0666);
  if (outfd==-1) {
    fprintf(stderr,"#ERROR# Outfile\n");
    fclose(instream);
    return(1);
  }

  convbuffer=(char*) malloc(BUFFER_SIZE);
  if (convbuffer==0) {
    fprintf(stderr,"#ERROR# Buffer\n");
    close(outfd);
    fclose(instream);
    return(1);
  }

  if ((ov_open(instream, &vf, NULL, 0)) < 0) {
    fprintf(stderr, "#ERROR# No ogg\n");
    free(convbuffer);
    close(outfd);
    fclose(instream);
    return(1);
  }

  while (!eof) {
    ret = ov_read(&vf, convbuffer, BUFFER_SIZE, true,
		  2, 1, &current_section);
    if (ret == 0) {
      eof = 1;
    } else if (ret == OV_HOLE) {
    } else if (ret < 0) {
      fprintf(stderr, "Error: libvorbis reported a stream error.\n");
    } else {
      write(outfd,convbuffer,ret);	
      position+=ret;
      if (position>(last_position+80*1024)) {
        fprintf(stderr,"#POS#%ld\n",position);
        last_position=position;
      }	
    }
  }
  ov_clear(&vf);
  free(convbuffer);
  close(outfd);
  fclose(instream);
  fprintf(stderr,"#OK#\n");
  return(0);
}
